/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.extension.mixin.soft.annotation.injection;

import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.api.TrMember;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.extension.mixin.common.IMappable;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.extension.mixin.common.ResolveUtility;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.extension.mixin.common.data.CommonData;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.extension.mixin.soft.data.MemberInfo;
import java.util.Objects;
import java.util.Optional;

class AtMemberMappable
implements IMappable<MemberInfo> {
    private final CommonData data;
    private final MemberInfo info;

    AtMemberMappable(CommonData data, MemberInfo info) {
        this.data = Objects.requireNonNull(data);
        this.info = Objects.requireNonNull(info);
    }

    @Override
    public MemberInfo result() {
        if (!this.info.isFullyQualified()) {
            this.data.getLogger().warn("%s is not fully qualified.", this.info);
            return this.info;
        }
        Optional<TrMember> resolved = this.data.resolver.resolveMember(this.info.getOwner(), this.info.getName(), this.info.getDesc(), ResolveUtility.FLAG_UNIQUE | ResolveUtility.FLAG_RECURSIVE);
        if (resolved.isPresent()) {
            String newOwner = this.data.mapper.asTrRemapper().map(this.info.getOwner());
            String newName = this.data.mapper.mapName(resolved.get());
            String newDesc = this.data.mapper.mapDesc(resolved.get());
            return new MemberInfo(newOwner, newName, this.info.getQuantifier(), newDesc);
        }
        return this.info;
    }
}

