/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.mappings;

import io.github.fabriccompatibilitylayers.modremappingapi.impl.ModRemappingAPIImpl;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.compatibility.v1.ModRemapperV1Context;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.BaseModRemapperContext;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.tree.MappingTree;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.mappings.MappingsRegistry;
import io.github.fabriccompatibiltylayers.modremappingapi.api.MappingUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ApiStatus.Internal
public class MappingsUtilsImpl {
    public static String getTargetNamespace() {
        return FabricLoader.getInstance().getMappingResolver().getCurrentRuntimeNamespace();
    }

    public static String getNativeNamespace() {
        if (ModRemappingAPIImpl.BABRIC) {
            return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? "client" : "server";
        }
        return "official";
    }

    public static MappingsRegistry getV1Registry() {
        return ModRemapperV1Context.INSTANCE.getMappingsRegistry();
    }

    public static MappingsRegistry getMappingsRegistry(String contextId) {
        return BaseModRemapperContext.get(contextId).getMappingsRegistry();
    }

    public static String mapClass(MappingsRegistry registry, String className) {
        int srcNamespace = registry.getFullMappings().getNamespaceId(registry.getSourceNamespace());
        int targetNamespace = registry.getFullMappings().getNamespaceId(registry.getTargetNamespace());
        return registry.getFullMappings().mapClassName(className, srcNamespace, targetNamespace);
    }

    public static String unmapClass(MappingsRegistry registry, String className) {
        int srcNamespace = registry.getFullMappings().getNamespaceId(registry.getTargetNamespace());
        int targetNamespace = registry.getFullMappings().getNamespaceId(registry.getSourceNamespace());
        return registry.getFullMappings().mapClassName(className, srcNamespace, targetNamespace);
    }

    public static MappingUtils.ClassMember mapField(MappingsRegistry registry, String className, String fieldName, @Nullable String fieldDesc) {
        int srcNamespace = registry.getFullMappings().getNamespaceId(registry.getSourceNamespace());
        int targetNamespace = registry.getFullMappings().getNamespaceId(registry.getTargetNamespace());
        MappingTree.FieldMapping fieldMapping = registry.getFullMappings().getField(className, fieldName, fieldDesc, srcNamespace);
        return MappingsUtilsImpl.mapMember(fieldName, fieldDesc, targetNamespace, fieldMapping);
    }

    public static MappingUtils.ClassMember mapFieldFromRemappedClass(MappingsRegistry registry, String className, String fieldName, @Nullable String fieldDesc) {
        int srcNamespace = registry.getFullMappings().getNamespaceId(registry.getSourceNamespace());
        int targetNamespace = registry.getFullMappings().getNamespaceId(registry.getTargetNamespace());
        MappingTree.ClassMapping classMapping = registry.getFullMappings().getClass(className, targetNamespace);
        if (classMapping == null) {
            return new MappingUtils.ClassMember(fieldName, fieldDesc);
        }
        MappingTree.FieldMapping fieldMapping = classMapping.getField(fieldName, fieldDesc, srcNamespace);
        return MappingsUtilsImpl.mapMember(fieldName, fieldDesc, targetNamespace, fieldMapping);
    }

    public static MappingUtils.ClassMember mapMethod(MappingsRegistry registry, String className, String methodName, String methodDesc) {
        MappingTree.ClassMapping classMapping;
        int srcNamespace = registry.getFullMappings().getNamespaceId(registry.getSourceNamespace());
        int targetNamespace = registry.getFullMappings().getNamespaceId(registry.getTargetNamespace());
        MappingTree.MethodMapping methodMapping = registry.getFullMappings().getMethod(className, methodName, methodDesc, srcNamespace);
        if (methodMapping == null && (classMapping = registry.getFullMappings().getClass(className, srcNamespace)) != null) {
            methodMapping = MappingsUtilsImpl.mapMethodWithPartialDesc(classMapping, methodName, methodDesc, srcNamespace);
        }
        return MappingsUtilsImpl.mapMember(methodName, methodDesc, targetNamespace, methodMapping);
    }

    public static MappingUtils.ClassMember mapMethodFromRemappedClass(MappingsRegistry registry, String className, String methodName, String methodDesc) {
        int srcNamespace = registry.getFullMappings().getNamespaceId(registry.getSourceNamespace());
        int targetNamespace = registry.getFullMappings().getNamespaceId(registry.getTargetNamespace());
        MappingTree.ClassMapping classMapping = registry.getFullMappings().getClass(className, targetNamespace);
        if (classMapping == null) {
            return new MappingUtils.ClassMember(methodName, methodDesc);
        }
        MappingTree.MethodMapping methodMapping = classMapping.getMethod(methodName, methodDesc, srcNamespace);
        if (methodMapping == null) {
            methodMapping = MappingsUtilsImpl.mapMethodWithPartialDesc(classMapping, methodName, methodDesc, srcNamespace);
        }
        return MappingsUtilsImpl.mapMember(methodName, methodDesc, targetNamespace, methodMapping);
    }

    private static MappingTree.MethodMapping mapMethodWithPartialDesc(MappingTree.ClassMapping classMapping, String methodName, String methodDesc, int namespace) {
        return classMapping.getMethods().stream().filter(methodMapping -> {
            String name = methodMapping.getName(namespace);
            String desc = methodMapping.getDesc(namespace);
            return name != null && name.equals(methodName) && desc != null && desc.startsWith(methodDesc);
        }).findFirst().orElse(null);
    }

    @NotNull
    private static MappingUtils.ClassMember mapMember(String memberName, @Nullable String memberDesc, int targetNamespace, MappingTree.MemberMapping memberMapping) {
        if (memberMapping == null) {
            return new MappingUtils.ClassMember(memberName, memberDesc);
        }
        String remappedName = memberMapping.getName(targetNamespace);
        String remappedDesc = memberMapping.getDesc(targetNamespace);
        return new MappingUtils.ClassMember(remappedName == null ? memberName : remappedName, remappedDesc == null ? memberDesc : remappedDesc);
    }

    public static MappingUtils.ClassMember mapField(MappingsRegistry registry, Class<?> owner, String fieldName) {
        MappingTree.FieldMapping fieldMapping;
        int srcNamespace = registry.getFullMappings().getNamespaceId(registry.getSourceNamespace());
        int targetNamespace = registry.getFullMappings().getNamespaceId(registry.getTargetNamespace());
        MappingTree.ClassMapping classMapping = registry.getFullMappings().getClass(owner.getName().replace(".", "/"), targetNamespace);
        if (classMapping != null && (fieldMapping = classMapping.getField(fieldName, null, srcNamespace)) != null) {
            return MappingsUtilsImpl.mapMember(fieldName, null, targetNamespace, fieldMapping);
        }
        if (owner.getSuperclass() != null) {
            return MappingsUtilsImpl.mapField(registry, owner.getSuperclass(), fieldName);
        }
        return new MappingUtils.ClassMember(fieldName, null);
    }

    public static MappingUtils.ClassMember mapMethod(MappingsRegistry registry, Class<?> owner, String methodName, Class<?>[] parameterTypes) {
        Optional<MappingTree.MethodMapping> matchingMethod;
        String argDesc = MappingsUtilsImpl.classTypeToDescriptor(parameterTypes);
        int srcNamespace = registry.getFullMappings().getNamespaceId(registry.getSourceNamespace());
        int targetNamespace = registry.getFullMappings().getNamespaceId(registry.getTargetNamespace());
        MappingTree.ClassMapping classMapping = registry.getFullMappings().getClass(owner.getName().replace(".", "/"), targetNamespace);
        if (classMapping != null && (matchingMethod = classMapping.getMethods().stream().filter(methodDef -> {
            String methodSubName = methodDef.getName(srcNamespace);
            if (!Objects.equals(methodSubName, methodName)) {
                return false;
            }
            String methodDescriptor = methodDef.getDesc(targetNamespace);
            return methodDescriptor != null && methodDescriptor.startsWith(argDesc);
        }).findFirst()).isPresent()) {
            MappingTree.MethodMapping methodDef2 = matchingMethod.get();
            return new MappingUtils.ClassMember(methodDef2.getName(targetNamespace), methodDef2.getDesc(targetNamespace));
        }
        if (owner.getSuperclass() != null) {
            return MappingsUtilsImpl.mapMethod(registry, owner.getSuperclass(), methodName, parameterTypes);
        }
        return new MappingUtils.ClassMember(methodName, null);
    }

    private static String classTypeToDescriptor(Class<?>[] classTypes) {
        StringBuilder desc = new StringBuilder("(");
        Arrays.stream(classTypes).forEach(clazz -> desc.append(Type.getDescriptor((Class)clazz)));
        return MappingsUtilsImpl.jvmdowngrader$concat$classTypeToDescriptor$1(String.valueOf(desc));
    }

    public static String mapDescriptor(MappingsRegistry registry, String desc) {
        int srcNamespace = registry.getFullMappings().getNamespaceId(registry.getSourceNamespace());
        int targetNamespace = registry.getFullMappings().getNamespaceId(registry.getTargetNamespace());
        return registry.getFullMappings().mapDesc(desc, srcNamespace, targetNamespace);
    }

    private static /* synthetic */ String jvmdowngrader$concat$classTypeToDescriptor$1(String string) {
        return string + ")";
    }
}

