/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper;

import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.ModCandidate;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.RemappingFlags;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.ModRemapperContext;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.accesswidener.AccessWidenerReader;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.accesswidener.AccessWidenerRemapper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.accesswidener.AccessWidenerWriter;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.gson.Gson;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.tree.MappingTree;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.NonClassCopyMode;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.OutputConsumerPath;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.TinyRemapper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.extension.mixin.MixinExtension;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.mappings.MappingTreeHelper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.mappings.MappingsRegistry;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.TrRemapperHelper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.asm.mixin.RefmapBaseMixinExtension;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.minecraft.MinecraftRemapper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.resource.RefmapJson;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.resource.RefmapRemapper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.visitor.MixinPostApplyVisitorProvider;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.utils.FileUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import mod-remapping-api.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.commons.Remapper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ApiStatus.Internal
public class ModTrRemapper {
    private static final Gson GSON = new Gson();

    public static TinyRemapper makeRemapper(ModRemapperContext context) {
        MappingsRegistry mappingsRegistry = context.getMappingsRegistry();
        List<MappingTree> trees = mappingsRegistry.getRemappingMappings();
        TinyRemapper.Builder builder = TinyRemapper.newRemapper().renameInvalidLocals(true).ignoreFieldDesc(false).propagatePrivate(true).ignoreConflicts(true);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            builder.fixPackageAccess(true);
        }
        for (MappingTree tree : trees) {
            builder.withMappings(MappingTreeHelper.createMappingProvider(tree, mappingsRegistry.getSourceNamespace(), mappingsRegistry.getTargetNamespace()));
        }
        context.addToRemapperBuilder(builder);
        if (context.getRemappingFlags().contains((Object)RemappingFlags.MIXIN)) {
            builder.extension(new RefmapBaseMixinExtension(inputTag -> !context.getMixinData().getHardMixins().contains(inputTag)));
            MixinPostApplyVisitorProvider mixinPostApplyVisitorProvider = new MixinPostApplyVisitorProvider();
            builder.extraPostApplyVisitor(mixinPostApplyVisitorProvider);
            builder.extension(new MixinExtension(context.getMixinData().getHardMixins()::contains));
        }
        TinyRemapper remapper = builder.build();
        try {
            MinecraftRemapper.addMinecraftJar(remapper, mappingsRegistry, context.getCacheHandler());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        context.getLibraryHandler().addLibrariesToRemapClasspath(remapper);
        return remapper;
    }

    public static void remapMods(TinyRemapper remapper, Map<ModCandidate, Path> paths, ModRemapperContext context) {
        ArrayList<OutputConsumerPath> outputConsumerPaths = new ArrayList<OutputConsumerPath>();
        if (context.getRemappingFlags().contains((Object)RemappingFlags.MIXIN)) {
            try {
                ModTrRemapper.analyzeRefMaps(paths.keySet(), context);
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<OutputConsumerPath.ResourceRemapper> resourcePostRemappers = new ArrayList<OutputConsumerPath.ResourceRemapper>(NonClassCopyMode.FIX_META_INF.remappers);
        if (context.getRemappingFlags().contains((Object)RemappingFlags.MIXIN)) {
            resourcePostRemappers.add(new RefmapRemapper());
        }
        Consumer<TinyRemapper> consumer = ModTrRemapper.getRemapperConsumer(paths, context);
        TrRemapperHelper.applyRemapper(remapper, paths.entrySet().stream().collect(Collectors.toMap(entry -> ((ModCandidate)entry.getKey()).getPath(), Map.Entry::getValue)), outputConsumerPaths, resourcePostRemappers, true, context.getMappingsRegistry().getSourceNamespace(), context.getMappingsRegistry().getTargetNamespace(), consumer);
        if (context.getRemappingFlags().contains((Object)RemappingFlags.ACCESS_WIDENER)) {
            for (Map.Entry<ModCandidate, Path> entry2 : paths.entrySet()) {
                ModCandidate candidate = entry2.getKey();
                Path jarPath = entry2.getValue();
                if (candidate.getAccessWidenerPath() == null || candidate.getAccessWidener() == null) continue;
                try {
                    FileSystem fs = FileUtils.getJarFileSystem(jarPath);
                    try {
                        Files.delete(fs.getPath(candidate.getAccessWidenerPath(), new String[0]));
                        Files.write(fs.getPath(candidate.getAccessWidenerPath(), new String[0]), candidate.getAccessWidener(), new OpenOption[0]);
                    }
                    finally {
                        if (fs == null) continue;
                        fs.close();
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException(ModTrRemapper.jvmdowngrader$concat$remapMods$1(candidate.getId()), t);
                }
            }
        }
    }

    @Nullable
    private static Consumer<TinyRemapper> getRemapperConsumer(Map<ModCandidate, Path> paths, ModRemapperContext context) {
        if (context.getRemappingFlags().contains((Object)RemappingFlags.ACCESS_WIDENER)) {
            return currentRemapper -> {
                for (Map.Entry entry : paths.entrySet()) {
                    ModCandidate candidate = (ModCandidate)entry.getKey();
                    if (candidate.getAccessWidenerPath() == null) continue;
                    try {
                        FileSystem jarFs = FileUtils.getJarFileSystem(candidate.getPath());
                        try {
                            candidate.setAccessWidener(ModTrRemapper.remapAccessWidener(Files.readAllBytes(jarFs.getPath(candidate.getAccessWidenerPath(), new String[0])), currentRemapper.getRemapper(), context.getMappingsRegistry().getTargetNamespace()));
                        }
                        finally {
                            if (jarFs == null) continue;
                            jarFs.close();
                        }
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(ModTrRemapper.jvmdowngrader$concat$lambda$getRemapperConsumer$2$1(candidate.getId()), t);
                    }
                }
            };
        }
        return null;
    }

    private static byte[] remapAccessWidener(byte[] data, Remapper remapper, String targetNamespace) {
        AccessWidenerWriter writer = new AccessWidenerWriter();
        AccessWidenerRemapper remappingDecorator = new AccessWidenerRemapper(writer, remapper, "intermediary", targetNamespace);
        AccessWidenerReader accessWidenerReader = new AccessWidenerReader(remappingDecorator);
        accessWidenerReader.read(data, "intermediary");
        return writer.write();
    }

    private static void analyzeRefMaps(Set<ModCandidate> candidates, ModRemapperContext context) throws IOException, URISyntaxException {
        for (ModCandidate candidate : candidates) {
            Path path = candidate.getPath();
            List<String> files = FileUtils.listPathContent(path);
            List<String> refmaps = J_U_S_Stream.toList(files.stream().filter(file -> file.contains("refmap") && file.endsWith(".json")));
            if (refmaps.isEmpty()) continue;
            FileSystem fs = FileUtils.getJarFileSystem(path);
            try {
                for (String refmap : refmaps) {
                    Path refmapPath = fs.getPath(refmap, new String[0]);
                    RefmapJson refmapJson = GSON.fromJson(new String(Files.readAllBytes(refmapPath)), RefmapJson.class);
                    refmapJson.remap(context.getMappingsRegistry().getFullMappings(), context.getMappingsRegistry().getSourceNamespace(), context.getMappingsRegistry().getTargetNamespace());
                    context.getMixinData().getMixinRefmapData().putAll(refmapJson.mappings);
                }
            }
            finally {
                if (fs == null) continue;
                fs.close();
            }
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$remapMods$1(String string) {
        return "Error while writing remapped access widener for '" + string + "'";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$getRemapperConsumer$2$1(String string) {
        return "Error while remapping access widener for '" + string + "'";
    }
}

