/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import mod-remapping-api.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import org.jetbrains.annotations.ApiStatus;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ApiStatus.Internal
public class SoftLockFixer {
    private static final ClassLoader cl = FabricLauncherBase.getLauncher().getTargetClassLoader();

    public static void preloadClasses() {
        ArrayList<Stream<String>> classes = new ArrayList<Stream<String>>();
        for (String[] entry : new String[][]{{"org/objectweb/asm/", "org/objectweb/asm/MethodVisitor"}, {"org/objectweb/asm/tree/", "org/objectweb/asm/tree/MethodNode"}, {"org/objectweb/asm/commons/", "org/objectweb/asm/commons/Remapper"}, {"org/objectweb/asm/util/", "org/objectweb/asm/util/CheckClassAdapter"}, {"org/objectweb/asm/tree/analysis/", "org/objectweb/asm/tree/analysis/Value"}, {"", "io/github/fabriccompatibilitylayers/modremappingapi/impl/remapper/TrRemapperHelper"}, {SoftLockFixer.getLibPackageName("tinyremapper", ""), SoftLockFixer.getLibPackageName("tinyremapper", "TinyRemapper")}, {SoftLockFixer.getLibPackageName("mappingio", ""), SoftLockFixer.getLibPackageName("mappingio", "MappingReader")}}) {
            try {
                classes.add(SoftLockFixer.getEntries(entry[0], entry[1]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Stream t = classes.stream().flatMap(s -> s);
        ArrayList<String> toCheck = new ArrayList<String>(Arrays.asList("net.fabricmc.loader.impl.launch.FabricLauncher", "net.fabricmc.loader.impl.launch.FabricLauncherBase", "net.fabricmc.loader.api.ObjectShare", "javax.lang.model.SourceVersion", SoftLockFixer.getLibClassName("tinyremapper", "extension.mixin.hard.ImprovedHardTargetMixinClassVisitor"), SoftLockFixer.getLibClassName("tinyremapper", "extension.mixin.hard.ImprovedMixinAnnotationVisitor")));
        toCheck.addAll(J_U_S_Stream.toList(t));
        for (String clazz : toCheck) {
            try {
                if (clazz.startsWith("META-INF.versions")) continue;
                Class.forName(clazz, false, cl);
            }
            catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError e) {
                if (clazz.startsWith("META-INF.versions")) continue;
                throw new RuntimeException(e);
            }
        }
    }

    private static String getLibPackageName(String lib, String string) {
        boolean shouldDev;
        boolean isDev = FabricLoader.getInstance().isDevelopmentEnvironment();
        boolean bl = shouldDev = isDev && System.getProperty("fabric-mod-remapper-api.dev") == null;
        if (shouldDev) {
            return SoftLockFixer.jvmdowngrader$concat$getLibPackageName$1(lib, string);
        }
        return SoftLockFixer.jvmdowngrader$concat$getLibPackageName$2(lib, string);
    }

    private static String getLibClassName(String lib, String string) {
        boolean shouldDev;
        boolean isDev = FabricLoader.getInstance().isDevelopmentEnvironment();
        boolean bl = shouldDev = isDev && System.getProperty("fabric-mod-remapper-api.dev") == null;
        if (shouldDev) {
            return SoftLockFixer.jvmdowngrader$concat$getLibClassName$1(lib, string);
        }
        return SoftLockFixer.jvmdowngrader$concat$getLibClassName$2(lib, string);
    }

    private static Stream<String> getEntries(String pkg, String locatorClass) throws IOException {
        Stream<String> stream;
        URL url = cl.getResource(SoftLockFixer.jvmdowngrader$concat$getEntries$1(locatorClass));
        URLConnection connection = url.openConnection();
        if (connection instanceof JarURLConnection) {
            JarURLConnection jarConnection = (JarURLConnection)connection;
            stream = jarConnection.getJarFile().stream().filter(jarEntry -> jarEntry.getName().contains(pkg) && jarEntry.getName().endsWith(".class")).map(jarEntry -> jarEntry.getName().replace("/", ".").replace(".class", ""));
        } else {
            stream = Stream.empty();
        }
        return stream;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getLibPackageName$1(String string, String string2) {
        return "net/fabricmc/" + string + "/" + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getLibPackageName$2(String string, String string2) {
        return "io/github/fabriccompatibilitylayers/modremappingapi/impl/lib/" + string + "/" + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getLibClassName$1(String string, String string2) {
        return "net.fabricmc." + string + "." + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getLibClassName$2(String string, String string2) {
        return "io.github.fabriccompatibilitylayers.modremappingapi.impl.lib." + string + "." + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getEntries$1(String string) {
        return string + ".class";
    }
}

