/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.asm;

import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.VisitorInfosImpl;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.asm.MRAMethodVisitor;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

@ApiStatus.Internal
public class MRAClassVisitor
extends ClassVisitor {
    private final VisitorInfosImpl infos;
    private final String className;

    public MRAClassVisitor(ClassVisitor classVisitor, VisitorInfosImpl infos, String className) {
        super(589824, classVisitor);
        this.infos = infos;
        this.className = className;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String superType = this.infos.SUPERS.getOrDefault(superName, superName);
        super.visit(version, access, name, signature, superType, interfaces);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        String annotationType = this.infos.ANNOTATION.getOrDefault(descriptor, descriptor);
        return super.visitTypeAnnotation(typeRef, typePath, annotationType, visible);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor original = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new MRAMethodVisitor(original, this.infos, this.className);
    }
}

