/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.utils;

import com.google.common.collect.ImmutableSet;
import io.github.fabriccompatibiltylayers.modremappingapi.api.v1.ClassTransformer;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.mine_diver.spasm.api.transform.RawClassTransformer;
import net.mine_diver.spasm.api.transform.TransformationPhase;
import net.mine_diver.spasm.impl.SpASM;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class TransformerRegistry
implements RawClassTransformer {
    private static final Set<ClassTransformer> PRE_TRANSFORMERS = new HashSet<ClassTransformer>();
    private static final Set<ClassTransformer> POST_TRANSFORMERS = new HashSet<ClassTransformer>();

    @ApiStatus.Internal
    public static byte[] transform(String name, String transformedName, byte[] basicClass) {
        HashSet<ClassTransformer> transformers = new HashSet<ClassTransformer>();
        Set<ClassTransformer> transformerPool = PRE_TRANSFORMERS;
        if (SpASM.getCurrentPhase() == TransformationPhase.AFTER_MIXINS) {
            transformerPool = POST_TRANSFORMERS;
        }
        for (ClassTransformer transformer : transformerPool) {
            if (!transformer.handlesClass(name, transformedName)) continue;
            transformers.add(transformer);
        }
        byte[] modifiedClass = basicClass;
        for (ClassTransformer transformer : transformers) {
            modifiedClass = transformer.transformClass(name, transformedName, modifiedClass);
        }
        return modifiedClass;
    }

    @ApiStatus.Internal
    public static void registerPreTransformer(ClassTransformer transformer) {
        PRE_TRANSFORMERS.add(transformer);
    }

    @ApiStatus.Internal
    public static void registerPostTransformer(ClassTransformer transformer) {
        POST_TRANSFORMERS.add(transformer);
    }

    @NotNull
    public Optional<byte[]> transform(@NotNull ClassLoader classLoader, @NotNull String className, byte @NotNull [] bytes) {
        byte[] modifiedBytes = bytes;
        modifiedBytes = TransformerRegistry.transform(className, className, modifiedBytes);
        return Optional.ofNullable(modifiedBytes);
    }

    @NotNull
    public ImmutableSet<TransformationPhase> getPhases() {
        return ALL_PHASES;
    }
}

