/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.extension.mixin.hard;

import io.github.fabriccompatibilitylayers.modremappingapi.impl.ModRemappingAPIImpl;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.extension.mixin.common.data.MxClass;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ImprovedMixinAnnotationVisitor
extends AnnotationVisitor {
    private final List<String> targets;
    private final MxClass _class;

    public ImprovedMixinAnnotationVisitor(AnnotationVisitor delegate, List<String> targetsOut, MxClass _class) {
        super(589824, delegate);
        this.targets = Objects.requireNonNull(targetsOut);
        this._class = Objects.requireNonNull(_class);
    }

    public AnnotationVisitor visitArray(String name) {
        AnnotationVisitor visitor = super.visitArray(name);
        return switch (name) {
            case "targets" -> new AnnotationVisitor(589824, visitor){

                public void visit(String name, Object value) {
                    String srcName;
                    String dstName = srcName = ((String)value).replaceAll("\\s", "").replace('.', '/');
                    Map refmapData = ModRemappingAPIImpl.getCurrentContext().getMixinData().getMixinRefmapData().getOrDefault(ImprovedMixinAnnotationVisitor.this._class.getName(), new HashMap());
                    srcName = refmapData.getOrDefault(value, srcName);
                    ImprovedMixinAnnotationVisitor.this.targets.add(srcName);
                    super.visit(name, (Object)dstName);
                }
            };
            case "value" -> new AnnotationVisitor(589824, visitor){

                public void visit(String name, Object value) {
                    if (value instanceof Type) {
                        Type srcType = (Type)value;
                        ImprovedMixinAnnotationVisitor.this.targets.add(srcType.getInternalName());
                    }
                    super.visit(name, value);
                }
            };
            default -> visitor;
        };
    }
}

