/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper;

import fr.catcore.modremapperapi.utils.Constants;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import org.jetbrains.annotations.ApiStatus;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ApiStatus.Internal
public class SoftLockFixer {
    private static final ClassLoader cl = FabricLauncherBase.getLauncher().getTargetClassLoader();

    public static void preloadClasses() {
        ArrayList<Stream<String>> classes = new ArrayList<Stream<String>>();
        for (String[] entry : new String[][]{{"org/objectweb/asm/", "org/objectweb/asm/MethodVisitor"}, {"org/objectweb/asm/tree/", "org/objectweb/asm/tree/MethodNode"}, {"org/objectweb/asm/commons/", "org/objectweb/asm/commons/Remapper"}, {"org/objectweb/asm/util/", "org/objectweb/asm/util/CheckClassAdapter"}, {"org/objectweb/asm/tree/analysis/", "org/objectweb/asm/tree/analysis/Value"}, {"", "io/github/fabriccompatibilitylayers/modremappingapi/impl/remapper/TrRemapperHelper"}, {SoftLockFixer.getLibPackageName("tinyremapper", ""), SoftLockFixer.getLibPackageName("tinyremapper", "TinyRemapper")}, {SoftLockFixer.getLibPackageName("mappingio", ""), SoftLockFixer.getLibPackageName("mappingio", "MappingReader")}}) {
            try {
                classes.add(SoftLockFixer.getEntries(entry[0], entry[1]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Stream t = classes.stream().flatMap(s -> s);
        ArrayList<String> toCheck = new ArrayList<String>(Arrays.asList("net.fabricmc.loader.impl.launch.FabricLauncher", "net.fabricmc.loader.impl.launch.FabricLauncherBase", "net.fabricmc.loader.api.ObjectShare", "javax.lang.model.SourceVersion", SoftLockFixer.getLibClassName("tinyremapper", "extension.mixin.hard.ImprovedHardTargetMixinClassVisitor"), SoftLockFixer.getLibClassName("tinyremapper", "extension.mixin.hard.ImprovedMixinAnnotationVisitor")));
        toCheck.addAll(t.toList());
        for (String clazz : toCheck) {
            try {
                Constants.MAIN_LOGGER.info("Preloading class: " + clazz);
                Class.forName(clazz, false, cl);
            }
            catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError e) {
                if (clazz.startsWith("META-INF.versions")) continue;
                throw new RuntimeException(e);
            }
        }
    }

    private static String getLibPackageName(String lib, String string) {
        boolean shouldDev;
        boolean isDev = FabricLoader.getInstance().isDevelopmentEnvironment();
        boolean bl = shouldDev = isDev && System.getProperty("fabric-mod-remapper-api.dev") == null;
        if (shouldDev) {
            return "net/fabricmc/" + lib + "/" + string;
        }
        return "io/github/fabriccompatibilitylayers/modremappingapi/impl/lib/" + lib + "/" + string;
    }

    private static String getLibClassName(String lib, String string) {
        boolean shouldDev;
        boolean isDev = FabricLoader.getInstance().isDevelopmentEnvironment();
        boolean bl = shouldDev = isDev && System.getProperty("fabric-mod-remapper-api.dev") == null;
        if (shouldDev) {
            return "net.fabricmc." + lib + "." + string;
        }
        return "io.github.fabriccompatibilitylayers.modremappingapi.impl.lib." + lib + "." + string;
    }

    private static Stream<String> getEntries(String pkg, String locatorClass) throws IOException {
        URL url = cl.getResource(locatorClass + ".class");
        URLConnection connection = url.openConnection();
        return connection instanceof JarURLConnection ? ((JarURLConnection)connection).getJarFile().stream().filter(jarEntry -> jarEntry.getName().contains(pkg) && jarEntry.getName().endsWith(".class")).map(jarEntry -> jarEntry.getName().replace("/", ".").replace(".class", "")) : Stream.empty();
    }
}

