/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.compatibility.v0;

import fr.catcore.modremapperapi.api.ModRemapper;
import fr.catcore.modremapperapi.remapping.RemapUtil;
import fr.catcore.modremapperapi.remapping.VisitorInfos;
import fr.catcore.wfvaio.FabricVariants;
import fr.catcore.wfvaio.WhichFabricVariantAmIOn;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.adapter.MappingSourceNsSwitch;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.tree.MappingTree;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.tree.MemoryMappingTree;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.mappings.MappingTreeHelper;
import io.github.fabriccompatibiltylayers.modremappingapi.api.v1.MappingBuilder;
import io.github.fabriccompatibiltylayers.modremappingapi.api.v1.RemapLibrary;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class V0ModRemapper
implements io.github.fabriccompatibiltylayers.modremappingapi.api.v1.ModRemapper {
    private static final boolean BABRIC = WhichFabricVariantAmIOn.getVariant() == FabricVariants.BABRIC || WhichFabricVariantAmIOn.getVariant() == FabricVariants.BABRIC_NEW_FORMAT;
    private final ModRemapper modRemapper;

    public V0ModRemapper(ModRemapper modRemapper) {
        this.modRemapper = modRemapper;
    }

    @Override
    public String[] getJarFolders() {
        return this.modRemapper.getJarFolders();
    }

    @Override
    public void addRemapLibraries(List<RemapLibrary> libraries, EnvType environment) {
        for (fr.catcore.modremapperapi.api.RemapLibrary library : this.modRemapper.getRemapLibraries()) {
            libraries.add(new RemapLibrary(library.url, library.path, library.toExclude, library.fileName));
        }
    }

    public Map<String, List<String>> getExclusions() {
        return this.modRemapper.getExclusions();
    }

    @Override
    public void registerMappings(MappingBuilder list) {
        RemapUtil.MappingList mappingList = new RemapUtil.MappingList();
        this.modRemapper.getMappingList(mappingList);
        MemoryMappingTree mappingTree = this.convertMappingList(mappingList);
        if (mappingTree != null) {
            for (MappingTree.ClassMapping classMapping : mappingTree.getClasses()) {
                MappingBuilder.ClassMapping classBuilder = list.addMapping(classMapping.getName("official"), classMapping.getName("intermediary"));
                for (MappingTree.FieldMapping fieldMapping : classMapping.getFields()) {
                    classBuilder.field(fieldMapping.getName("official"), fieldMapping.getName("intermediary"), fieldMapping.getDesc("official"));
                }
                for (MappingTree.MethodMapping methodMapping : classMapping.getMethods()) {
                    classBuilder.method(methodMapping.getName("official"), methodMapping.getName("intermediary"), methodMapping.getDesc("official"));
                }
            }
        }
    }

    @Override
    public void registerPreVisitors(io.github.fabriccompatibiltylayers.modremappingapi.api.v1.VisitorInfos infos) {
    }

    @Override
    public void registerPostVisitors(io.github.fabriccompatibiltylayers.modremappingapi.api.v1.VisitorInfos infos) {
        this.modRemapper.registerVisitors((VisitorInfos)((Object)infos));
    }

    @Override
    public Optional<String> getDefaultPackage() {
        return this.modRemapper.getDefaultPackage();
    }

    @Override
    public void afterRemap() {
        this.modRemapper.afterRemap();
    }

    private MemoryMappingTree convertMappingList(RemapUtil.MappingList mappingList) {
        MemoryMappingTree mappingTree;
        try {
            mappingTree = BABRIC ? MappingTreeHelper.createMappingTree("intermediary", "official") : MappingTreeHelper.createMappingTree();
            mappingList.accept(mappingTree);
            mappingTree.visitEnd();
            if ("intermediary".equals(mappingTree.getSrcNamespace())) {
                MemoryMappingTree newTree = new MemoryMappingTree();
                MappingSourceNsSwitch visitor = new MappingSourceNsSwitch(newTree, "official");
                mappingTree.accept(visitor);
                mappingTree = newTree;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while generating remappers mappings", e);
        }
        return mappingTree;
    }
}

