/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.context;

import fr.catcore.modremapperapi.utils.Constants;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.CacheHandler;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.MappingsConfig;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.ModCandidate;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.ModDiscovererConfig;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.ModRemapper;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.RemapLibrary;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.RemappingFlags;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.BaseModRemapperContext;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.InternalCacheHandler;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.LibraryHandler;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.MappingsRegistryInstance;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.MixinData;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.ModDiscoverer;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.V2CacheHandler;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.V2MappingBuilderImpl;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.TinyRemapper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.mappings.MappingsRegistry;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.ModTrRemapper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.SoftLockFixer;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.VisitorInfosImpl;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.visitor.MRAApplyVisitor;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.utils.CacheUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ModRemmaperV2Context
extends BaseModRemapperContext<ModRemapper> {
    private final List<ModRemapper> remappers;
    private final Set<RemappingFlags> remapFlags = new HashSet<RemappingFlags>();
    private final MixinData mixinData = new MixinData();
    private final MappingsRegistryInstance mappingsRegistry;
    private final LibraryHandler libraryHandler = new LibraryHandler();
    private final InternalCacheHandler cacheHandler;

    public ModRemmaperV2Context(String id, List<ModRemapper> remappers) {
        super(id);
        this.remappers = remappers;
        this.cacheHandler = new V2CacheHandler(CacheUtils.getCachePath(id));
        this.mappingsRegistry = new MappingsRegistryInstance(this.cacheHandler);
    }

    @Override
    public void init() {
        for (ModRemapper remapper : this.remappers) {
            remapper.init(this.cacheHandler);
            MappingsConfig mappings = remapper.getMappingsConfig();
            if (mappings.getSourceNamespace() != null) {
                this.mappingsRegistry.setSourceNamespace(mappings.getSourceNamespace());
            }
            if (mappings.getExtraMappings() != null) {
                try {
                    this.mappingsRegistry.addToFormattedMappings(new ByteArrayInputStream(mappings.getExtraMappings().get().getBytes(StandardCharsets.UTF_8)), mappings.getRenamingMap());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (mappings.getDefaultPackage() != null) {
                this.mappingsRegistry.setDefaultPackage(mappings.getDefaultPackage());
            }
            this.remapFlags.addAll(remapper.getRemappingFlags());
        }
        try {
            this.mappingsRegistry.completeFormattedMappings();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.gatherLibraries();
        this.registerAdditionalMappings();
        this.mappingsRegistry.generateAdditionalMappings();
    }

    @Override
    public void remapMods(Map<ModCandidate, Path> pathMap) {
        Constants.MAIN_LOGGER.debug("Starting jar remapping!");
        SoftLockFixer.preloadClasses();
        TinyRemapper remapper = ModTrRemapper.makeRemapper(this);
        Constants.MAIN_LOGGER.debug("Remapper created!");
        ModTrRemapper.remapMods(remapper, pathMap, this);
        Constants.MAIN_LOGGER.debug("Jar remapping done!");
        this.mappingsRegistry.writeFullMappings();
    }

    @Override
    public void afterRemap() {
        this.remappers.forEach(ModRemapper::afterRemapping);
    }

    @Override
    public List<ModRemapper> discoverMods(boolean remapClassEdits) {
        ArrayList<ModRemapper> collected = new ArrayList<ModRemapper>();
        ArrayList<ModCandidate> candidates = new ArrayList<ModCandidate>();
        HashMap<ModDiscovererConfig, ModDiscoverer> config2Discoverer = new HashMap<ModDiscovererConfig, ModDiscoverer>();
        for (ModRemapper modRemapper : this.remappers) {
            for (ModDiscovererConfig modDiscovererConfig : modRemapper.getModDiscoverers()) {
                ModDiscoverer discoverer = new ModDiscoverer(modDiscovererConfig);
                config2Discoverer.put(modDiscovererConfig, discoverer);
                candidates.addAll(discoverer.collect());
            }
        }
        for (ModRemapper modRemapper : this.remappers) {
            collected.addAll(modRemapper.collectSubRemappers(candidates));
        }
        Map<ModDiscovererConfig, List<ModCandidate>> config2Candidates = candidates.stream().collect(Collectors.groupingBy(ModCandidate::getDiscovererConfig));
        for (ModCandidate candidate : candidates) {
            this.mappingsRegistry.addModMappings(candidate.getPath());
        }
        this.mappingsRegistry.generateModMappings();
        HashMap<ModCandidate, Path> hashMap = new HashMap<ModCandidate, Path>();
        for (Map.Entry entry : config2Candidates.entrySet()) {
            ModDiscovererConfig config = (ModDiscovererConfig)entry.getKey();
            hashMap.putAll(((ModDiscoverer)config2Discoverer.get(config)).computeDestinations((List)entry.getValue(), this.cacheHandler));
        }
        if (!hashMap.isEmpty()) {
            this.remapMods(hashMap);
        }
        return collected;
    }

    @Override
    public void gatherRemappers() {
    }

    @Override
    public MappingsRegistry getMappingsRegistry() {
        return this.mappingsRegistry;
    }

    private void registerAdditionalMappings() {
        V2MappingBuilderImpl builder = new V2MappingBuilderImpl(this.mappingsRegistry.getAdditionalMappings());
        for (ModRemapper remapper : this.remappers) {
            remapper.registerAdditionalMappings(builder);
        }
    }

    @Override
    public void addToRemapperBuilder(TinyRemapper.Builder builder) {
        VisitorInfosImpl preInfos = new VisitorInfosImpl();
        VisitorInfosImpl postInfos = new VisitorInfosImpl();
        for (ModRemapper remapper : this.remappers) {
            remapper.registerPreVisitors(preInfos);
            remapper.registerPostVisitors(postInfos);
        }
        builder.extraPreApplyVisitor(new MRAApplyVisitor(preInfos));
        builder.extraPostApplyVisitor(new MRAApplyVisitor(postInfos));
    }

    @Override
    public Set<RemappingFlags> getRemappingFlags() {
        return this.remapFlags;
    }

    @Override
    public LibraryHandler getLibraryHandler() {
        return this.libraryHandler;
    }

    public List<ModRemapper> getRemappers() {
        return this.remappers;
    }

    @Override
    public MixinData getMixinData() {
        return this.mixinData;
    }

    @Override
    public void gatherLibraries() {
        this.libraryHandler.init(this.mappingsRegistry.getSourceNamespace(), this.cacheHandler);
        ArrayList<RemapLibrary> libraries = new ArrayList<RemapLibrary>();
        for (ModRemapper remapper : this.remappers) {
            remapper.addRemappingLibraries(libraries, FabricLoader.getInstance().getEnvironmentType());
        }
        this.libraryHandler.cacheLibraries(libraries);
    }

    @Override
    public CacheHandler getCacheHandler() {
        return this.cacheHandler;
    }
}

