/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.extension.mixin.hard.util;

import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.extension.mixin.common.StringUtility;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.extension.mixin.hard.util.IConvertibleString;
import java.util.Objects;

public class CamelPrefixString
implements IConvertibleString {
    private final String prefix;
    private final String text;

    public CamelPrefixString(String prefix, String text) {
        this.prefix = Objects.requireNonNull(prefix);
        this.text = StringUtility.removeCamelPrefix(prefix, text);
    }

    @Override
    public String getOriginal() {
        return StringUtility.addCamelPrefix(this.prefix, this.text);
    }

    @Override
    public String getConverted() {
        return this.text;
    }

    @Override
    public String getReverted(String newText) {
        return StringUtility.addCamelPrefix(this.prefix, newText);
    }
}

