/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.asm;

import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.VisitorInfos;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.VisitorInfosImpl;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

@ApiStatus.Internal
public class MRAMethodVisitor
extends MethodVisitor
implements Opcodes {
    private final VisitorInfosImpl infos;
    private final String className;

    protected MRAMethodVisitor(MethodVisitor methodVisitor, VisitorInfosImpl visitorInfos, String className) {
        super(589824, methodVisitor);
        this.infos = visitorInfos;
        this.className = className;
    }

    public void visitTypeInsn(int opcode, String type) {
        String currentType = type;
        boolean skip = false;
        if (opcode == 187 && this.infos.INSTANTIATION.containsKey(type)) {
            currentType = this.infos.INSTANTIATION.get(type);
            skip = true;
        }
        if (!skip && this.infos.METHOD_TYPE.containsKey(type)) {
            currentType = this.infos.METHOD_TYPE.get(type);
        }
        super.visitTypeInsn(opcode, currentType);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        VisitorInfos.FullClassMember classMember;
        Map<String, Map<String, VisitorInfos.FullClassMember>> fields;
        Map<String, VisitorInfos.FullClassMember> args;
        String currentOwner = owner;
        String currentName = name;
        String currentDescriptor = descriptor;
        if (this.infos.FIELD_REF.containsKey(owner) && (args = Optional.ofNullable((fields = this.infos.FIELD_REF.get(owner)).get(name)).orElse(fields.get(""))) != null && (classMember = Optional.ofNullable(args.get(descriptor)).orElse(args.get(""))) != null) {
            currentOwner = classMember.getOwner();
            currentName = classMember.getName();
            currentDescriptor = classMember.getDesc();
        }
        if (currentName.isEmpty()) {
            currentName = name;
        }
        if (currentDescriptor == null || currentDescriptor.isEmpty()) {
            currentDescriptor = descriptor;
        }
        super.visitFieldInsn(opcode, currentOwner, currentName, currentDescriptor);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        VisitorInfos.FullClassMember fullClassMember;
        Map<String, Map<String, VisitorInfos.FullClassMember>> methods;
        Map<String, VisitorInfos.FullClassMember> args;
        int currentOpcode = opcode;
        String currentOwner = owner;
        String currentName = name;
        String currentDescriptor = descriptor;
        boolean isInterfaceCall = isInterface;
        boolean skip = false;
        if (opcode == 183 && this.infos.INSTANTIATION.containsKey(owner) && name.equals("<init>")) {
            currentOwner = this.infos.INSTANTIATION.get(owner);
            skip = true;
        }
        if (!skip && (opcode == 182 || opcode == 184 || opcode == 185) && this.infos.METHOD_INVOCATION.containsKey(owner) && (args = Optional.ofNullable((methods = this.infos.METHOD_INVOCATION.get(owner)).get(currentName)).orElse(methods.get(""))) != null && (fullClassMember = Optional.ofNullable(args.get(currentDescriptor)).orElse(args.get(""))) != null) {
            currentOwner = fullClassMember.getOwner();
            currentName = fullClassMember.getName();
            currentDescriptor = fullClassMember.getDesc();
            if (fullClassMember.isStatic() != null) {
                int n = currentOpcode = fullClassMember.isStatic() != false ? 184 : 182;
            }
            if (isInterfaceCall) {
                isInterfaceCall = false;
            }
        }
        if (currentName.isEmpty()) {
            currentName = name;
        }
        if (currentDescriptor == null || currentDescriptor.isEmpty()) {
            currentDescriptor = descriptor;
        }
        super.visitMethodInsn(currentOpcode, currentOwner, currentName, currentDescriptor, isInterfaceCall);
    }

    public void visitLdcInsn(Object value) {
        Map<Object, Object> ldcMap;
        Object currentValue = value;
        if (this.infos.LDC.containsKey(this.className) && (ldcMap = this.infos.LDC.get(this.className)).containsKey(value)) {
            currentValue = ldcMap.get(value);
        }
        super.visitLdcInsn(currentValue);
    }
}

