/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.asm.mixin;

import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.InputTag;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.TinyRemapper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.api.TrEnvironment;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.extension.mixin.common.data.CommonData;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.extension.mixin.hard.ImprovedHardTargetMixinClassVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.ClassVisitor;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={AnalyzeVisitorProvider.class})
@ApiStatus.Internal
public class RefmapBaseMixinExtension
implements TinyRemapper.Extension {
    private final Map<Integer, Collection<Consumer<CommonData>>> tasks = new ConcurrentHashMap<Integer, Collection<Consumer<CommonData>>>();
    private final Predicate<InputTag> inputTagFilter;

    public RefmapBaseMixinExtension(Predicate<InputTag> inputTagFilter) {
        this.inputTagFilter = inputTagFilter;
    }

    @Override
    public void attach(TinyRemapper.Builder builder) {
        builder.extraAnalyzeVisitor(new AnalyzeVisitorProvider()).extraStateProcessor(this::stateProcessor);
    }

    private void stateProcessor(TrEnvironment environment) {
        CommonData data = new CommonData(environment);
        for (Consumer task : (Collection)this.tasks.getOrDefault(environment.getMrjVersion(), Collections.emptyList())) {
            try {
                task.accept(data);
            }
            catch (RuntimeException e) {
                environment.getLogger().error(e.getMessage());
            }
        }
    }

    public /* synthetic */ Map jvmdowngrader$nest$io_github_fabriccompatibilitylayers_modremappingapi_impl_remapper_asm_mixin_RefmapBaseMixinExtension$get$tasks() {
        return this.tasks;
    }

    public /* synthetic */ void jvmdowngrader$nest$io_github_fabriccompatibilitylayers_modremappingapi_impl_remapper_asm_mixin_RefmapBaseMixinExtension$set$tasks(Map map) {
        this.tasks = map;
    }

    public /* synthetic */ Predicate jvmdowngrader$nest$io_github_fabriccompatibilitylayers_modremappingapi_impl_remapper_asm_mixin_RefmapBaseMixinExtension$get$inputTagFilter() {
        return this.inputTagFilter;
    }

    public /* synthetic */ void jvmdowngrader$nest$io_github_fabriccompatibilitylayers_modremappingapi_impl_remapper_asm_mixin_RefmapBaseMixinExtension$set$inputTagFilter(Predicate predicate) {
        this.inputTagFilter = predicate;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=RefmapBaseMixinExtension.class)
    private final class AnalyzeVisitorProvider
    implements TinyRemapper.AnalyzeVisitorProvider {
        AnalyzeVisitorProvider() {
        }

        @Override
        public ClassVisitor insertAnalyzeVisitor(int mrjVersion, String className, ClassVisitor next) {
            return new ImprovedHardTargetMixinClassVisitor(RefmapBaseMixinExtension.this.jvmdowngrader$nest$io_github_fabriccompatibilitylayers_modremappingapi_impl_remapper_asm_mixin_RefmapBaseMixinExtension$get$tasks().computeIfAbsent(mrjVersion, k -> new ConcurrentLinkedQueue()), next);
        }

        @Override
        public ClassVisitor insertAnalyzeVisitor(int mrjVersion, String className, ClassVisitor next, InputTag[] inputTags) {
            if (RefmapBaseMixinExtension.this.jvmdowngrader$nest$io_github_fabriccompatibilitylayers_modremappingapi_impl_remapper_asm_mixin_RefmapBaseMixinExtension$get$inputTagFilter() == null || inputTags == null) {
                return this.insertAnalyzeVisitor(mrjVersion, className, next);
            }
            for (InputTag tag : inputTags) {
                if (!RefmapBaseMixinExtension.this.jvmdowngrader$nest$io_github_fabriccompatibilitylayers_modremappingapi_impl_remapper_asm_mixin_RefmapBaseMixinExtension$get$inputTagFilter().test(tag)) continue;
                return this.insertAnalyzeVisitor(mrjVersion, className, next);
            }
            return next;
        }

        @Override
        public ClassVisitor insertAnalyzeVisitor(boolean isInput, int mrjVersion, String className, ClassVisitor next, InputTag[] inputTags) {
            if (!isInput) {
                return next;
            }
            return this.insertAnalyzeVisitor(mrjVersion, className, next, inputTags);
        }
    }
}

