/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.resource;

import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.gson.Gson;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.OutputConsumerPath;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.TinyRemapper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.resource.RefmapJson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import mod-remapping-api.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_N_F_Files;
import org.jetbrains.annotations.ApiStatus;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ApiStatus.Internal
public class RefmapRemapper
implements OutputConsumerPath.ResourceRemapper {
    private Gson gson;

    @Override
    public boolean canTransform(TinyRemapper remapper, Path relativePath) {
        String path = relativePath.toString();
        return path.toLowerCase().contains("refmap") && path.endsWith(".json");
    }

    @Override
    public void transform(Path destinationDirectory, Path relativePath, InputStream input, TinyRemapper remapper) throws IOException {
        Path outputFile = destinationDirectory.resolve(relativePath);
        Path outputDir = outputFile.getParent();
        if (outputDir != null) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        if (this.gson == null) {
            this.gson = new Gson();
        }
        try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
            RefmapJson json = this.gson.fromJson((Reader)reader, RefmapJson.class);
            json.remap(remapper);
            J_N_F_Files.writeString(outputFile, (CharSequence)this.gson.toJson(json), new OpenOption[0]);
        }
    }
}

