/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.defaults;

import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.ModCandidate;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.ModDiscovererConfig;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.defaults.DefaultModCandidate;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ApiStatus.Internal
public class ModDiscovererConfigImpl
implements ModDiscovererConfig {
    private final String folderName;
    private final Pattern fileNameMatcher;
    private final boolean searchRecursively;
    private final Predicate<String> directoryFilter;
    @Nullable
    private final ModDiscovererConfig.Collector candidateCollector;
    private final boolean exportToOriginalFolder;
    private final boolean allowDirectoryMods;

    private ModDiscovererConfigImpl(String folderName, Pattern fileNameMatcher, boolean searchRecursively, Predicate<String> directoryFilter, @Nullable ModDiscovererConfig.Collector candidateCollector, boolean exportToOriginalFolder, boolean allowDirectoryMods) {
        this.folderName = folderName;
        this.fileNameMatcher = fileNameMatcher;
        this.searchRecursively = searchRecursively;
        this.directoryFilter = directoryFilter;
        this.candidateCollector = candidateCollector;
        this.exportToOriginalFolder = exportToOriginalFolder;
        this.allowDirectoryMods = allowDirectoryMods;
    }

    @Override
    public String getFolderName() {
        return this.folderName;
    }

    @Override
    public Pattern getFileNameMatcher() {
        return this.fileNameMatcher;
    }

    @Override
    public boolean searchRecursively() {
        return this.searchRecursively;
    }

    @Override
    public Predicate<String> getDirectoryFilter() {
        return this.directoryFilter;
    }

    @Override
    public ModDiscovererConfig.Collector getCandidateCollector() {
        return this.candidateCollector == null ? this::defaultCandidateCollector : this.candidateCollector;
    }

    @Override
    public boolean getExportToOriginalFolder() {
        return this.exportToOriginalFolder;
    }

    private List<ModCandidate> defaultCandidateCollector(ModDiscovererConfig config, Path modPath, List<String> fileList) {
        ArrayList<ModCandidate> candidates = new ArrayList<ModCandidate>();
        for (String file : fileList) {
            if (!file.endsWith(".class")) continue;
            candidates.add(new DefaultModCandidate(modPath, config));
            break;
        }
        return candidates;
    }

    @Override
    public boolean allowDirectoryMods() {
        return this.allowDirectoryMods;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class BuilderImpl
    implements ModDiscovererConfig.Builder {
        private final String folderName;
        private String fileNameMatcher = "(.+).jar$";
        private boolean searchRecursively = false;
        private Predicate<String> directoryFilter = s -> true;
        @Nullable
        private ModDiscovererConfig.Collector candidateCollector;
        private boolean exportToOriginalFolder = false;
        private boolean allowDirectoryMods = false;

        public BuilderImpl(String folderName) {
            this.folderName = folderName;
        }

        @Override
        public ModDiscovererConfig.Builder fileNameMatcher(String pattern) {
            this.fileNameMatcher = pattern;
            return this;
        }

        @Override
        public ModDiscovererConfig.Builder searchRecursively(boolean searchRecursively) {
            this.searchRecursively = searchRecursively;
            return this;
        }

        @Override
        public ModDiscovererConfig.Builder directoryFilter(Predicate<String> filter) {
            this.directoryFilter = filter;
            return this;
        }

        @Override
        public ModDiscovererConfig.Builder candidateCollector(ModDiscovererConfig.Collector collector) {
            this.candidateCollector = collector;
            return this;
        }

        @Override
        public ModDiscovererConfig.Builder exportToOriginalFolder(boolean exportToOriginalFolder) {
            this.exportToOriginalFolder = exportToOriginalFolder;
            return this;
        }

        @Override
        public ModDiscovererConfig.Builder allowDirectoryMods(boolean allowDirectoryMods) {
            this.allowDirectoryMods = allowDirectoryMods;
            return this;
        }

        @Override
        public ModDiscovererConfig build() {
            return new ModDiscovererConfigImpl(this.folderName, Pattern.compile(this.fileNameMatcher), this.searchRecursively, this.directoryFilter, this.candidateCollector, this.exportToOriginalFolder, this.allowDirectoryMods);
        }
    }
}

