/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.mappings;

import io.github.fabriccompatibilitylayers.modremappingapi.impl.ModRemappingAPIImpl;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.MappingReader;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.MappingVisitor;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.MappingWriter;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.adapter.ForwardingMappingVisitor;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.adapter.MappingDstNsReorder;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.adapter.MappingNsRenamer;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.adapter.MappingSourceNsSwitch;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.format.MappingFormat;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.format.tiny.Tiny1FileReader;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.format.tiny.Tiny2FileReader;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.tree.MappingTree;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.tree.MappingTreeView;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.tree.MemoryMappingTree;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.tree.VisitOrder;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.tree.VisitableMappingTree;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.IMappingProvider;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.TinyUtils;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.mappings.MappingsRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ApiStatus.Internal
public class MappingTreeHelper {
    @ApiStatus.Internal
    public static MemoryMappingTree mergeIntoNew(MappingTree left, MappingTree right) throws IOException {
        MemoryMappingTree result = new MemoryMappingTree();
        if (!Objects.equals(left.getSrcNamespace(), right.getSrcNamespace())) {
            throw new RuntimeException("Source namespace mismatch!");
        }
        result.visitHeader();
        ArrayList<String> dstNamespaces = new ArrayList<String>(left.getDstNamespaces());
        for (String dstNamespace : right.getDstNamespaces()) {
            if (dstNamespaces.contains(dstNamespace)) continue;
            dstNamespaces.add(dstNamespace);
        }
        result.visitNamespaces(left.getSrcNamespace(), dstNamespaces);
        result.visitEnd();
        MemoryMappingTree reorderedLeft = new MemoryMappingTree();
        left.accept(new MappingDstNsReorder((MappingVisitor)reorderedLeft, dstNamespaces));
        MemoryMappingTree reorderedRight = new MemoryMappingTree();
        right.accept(new MappingDstNsReorder((MappingVisitor)reorderedRight, dstNamespaces));
        reorderedLeft.accept(result, VisitOrder.createByName());
        reorderedRight.accept(result, VisitOrder.createByName());
        return result;
    }

    @ApiStatus.Internal
    public static void merge(VisitableMappingTree main, MappingTree additional) throws IOException {
        if (!Objects.equals(additional.getSrcNamespace(), main.getSrcNamespace())) {
            MemoryMappingTree reorder = new MemoryMappingTree();
            ForwardingMappingVisitor visitor = new MappingSourceNsSwitch(reorder, main.getSrcNamespace());
            if (!additional.getDstNamespaces().contains(main.getSrcNamespace())) {
                ArrayList<String> dstNamespaces = new ArrayList<String>(additional.getDstNamespaces());
                dstNamespaces.add(main.getSrcNamespace());
                visitor = new MappingDstNsReorder((MappingVisitor)visitor, dstNamespaces);
            }
            additional.accept(visitor);
            additional = reorder;
        }
        MemoryMappingTree reordered = new MemoryMappingTree();
        additional.accept(new MappingDstNsReorder((MappingVisitor)reordered, main.getDstNamespaces()));
        reordered.accept(main, VisitOrder.createByInputOrder());
    }

    @ApiStatus.Internal
    public static MemoryMappingTree readMappings(InputStream stream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            long time = System.currentTimeMillis();
            MemoryMappingTree mappingTree = new MemoryMappingTree();
            reader.mark(4096);
            MappingFormat format = MappingReader.detectFormat(reader);
            reader.reset();
            switch (format) {
                case TINY_FILE: {
                    Tiny1FileReader.read(reader, (MappingVisitor)mappingTree);
                    break;
                }
                case TINY_2_FILE: {
                    Tiny2FileReader.read(reader, (MappingVisitor)mappingTree);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported mapping format: " + String.valueOf((Object)format));
                }
            }
            Log.debug((LogCategory)LogCategory.MAPPINGS, (String)"Loading mappings took %d ms", (Object[])new Object[]{System.currentTimeMillis() - time});
            MemoryMappingTree memoryMappingTree = mappingTree;
            return memoryMappingTree;
        }
    }

    @ApiStatus.Internal
    public static IMappingProvider createMappingProvider(MappingTree mappings, String from, String to) {
        return TinyUtils.createMappingProvider(mappings, from, to);
    }

    @ApiStatus.Internal
    public static MemoryMappingTree createMappingTree() throws IOException {
        MappingsRegistry registry = ModRemappingAPIImpl.getCurrentContext().getMappingsRegistry();
        return MappingTreeHelper.createMappingTree(registry.getSourceNamespace(), registry.getTargetNamespace());
    }

    @ApiStatus.Internal
    public static MemoryMappingTree createMappingTree(String src, String target) throws IOException {
        MemoryMappingTree mappingTree = new MemoryMappingTree();
        mappingTree.visitHeader();
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.add(target);
        mappingTree.visitNamespaces(src, namespaces);
        return mappingTree;
    }

    @ApiStatus.Internal
    public static void exportMappings(MappingTreeView mappingTreeView, Path outputPath) throws IOException {
        try (MappingWriter writer = MappingWriter.create(outputPath, MappingFormat.TINY_2_FILE);){
            mappingTreeView.accept(writer);
        }
    }

    @NotNull
    public static MappingVisitor getNsReorderingVisitor(MemoryMappingTree tempTree, boolean switchNamespace, Map<String, String> renames) {
        ArrayList<String> targetNamespace = new ArrayList<String>();
        targetNamespace.add("intermediary");
        if (FabricLoader.getInstance().getMappingResolver().getNamespaces().contains("named")) {
            targetNamespace.add("named");
        }
        MappingVisitor visitor = tempTree;
        if (switchNamespace) {
            visitor = new MappingSourceNsSwitch(new MappingDstNsReorder(visitor, targetNamespace), "official");
        }
        visitor = new MappingNsRenamer(visitor, renames);
        return visitor;
    }
}

