/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper;

import fr.catcore.modremapperapi.utils.Constants;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.RemappingFlags;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.ModRemappingAPIImpl;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.InputTag;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.OutputConsumerPath;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.TinyRemapper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.utils.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ApiStatus.Internal
public class TrRemapperHelper {
    public static void applyRemapper(TinyRemapper remapper, Map<Path, Path> paths, List<OutputConsumerPath> outputConsumerPaths, List<OutputConsumerPath.ResourceRemapper> resourcePostRemappers, boolean analyzeMapping, String srcNamespace, String targetNamespace) {
        TrRemapperHelper.applyRemapper(remapper, paths, outputConsumerPaths, resourcePostRemappers, analyzeMapping, srcNamespace, targetNamespace, null);
    }

    public static void applyRemapper(TinyRemapper remapper, Map<Path, Path> paths, List<OutputConsumerPath> outputConsumerPaths, List<OutputConsumerPath.ResourceRemapper> resourcePostRemappers, boolean analyzeMapping, String srcNamespace, String targetNamespace, @Nullable Consumer<TinyRemapper> action) {
        try {
            HashMap<Path, InputTag> tagMap = new HashMap<Path, InputTag>();
            Constants.MAIN_LOGGER.debug("Creating InputTags!");
            for (Path path : paths.keySet()) {
                InputTag tag = remapper.createInputTag();
                tagMap.put(path, tag);
                if (ModRemappingAPIImpl.getCurrentContext().getRemappingFlags().contains((Object)RemappingFlags.MIXIN) && TrRemapperHelper.useHardMixinRemap(path)) {
                    ModRemappingAPIImpl.getCurrentContext().getMixinData().getHardMixins().add(tag);
                }
                remapper.readInputsAsync(tag, path);
            }
            Constants.MAIN_LOGGER.debug("Initializing remapping!");
            for (Map.Entry entry : paths.entrySet()) {
                Constants.MAIN_LOGGER.debug("Starting remapping " + ((Path)entry.getKey()).toString() + " to " + ((Path)entry.getValue()).toString());
                OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder((Path)entry.getValue()).build();
                outputConsumerPaths.add(outputConsumer);
                Constants.MAIN_LOGGER.debug("Apply remapper!");
                remapper.apply(outputConsumer, (InputTag)tagMap.get(entry.getKey()));
                Constants.MAIN_LOGGER.debug("Add input as non class file!");
                outputConsumer.addNonClassFiles((Path)entry.getKey(), remapper, resourcePostRemappers);
                Constants.MAIN_LOGGER.debug("Done 1!");
            }
            if (analyzeMapping) {
                ModRemappingAPIImpl.getCurrentContext().getMappingsRegistry().completeMappingsFromTr(remapper.getEnvironment(), srcNamespace);
            }
            if (action != null) {
                action.accept(remapper);
            }
        }
        catch (Exception e) {
            remapper.finish();
            outputConsumerPaths.forEach(o -> {
                try {
                    o.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            });
            throw new RuntimeException("Failed to remap jar", e);
        }
        finally {
            remapper.finish();
            outputConsumerPaths.forEach(o -> {
                try {
                    o.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private static boolean useHardMixinRemap(Path inputPath) throws IOException, URISyntaxException {
        try (FileSystem fs = FileUtils.getJarFileSystem(inputPath);){
            boolean bl;
            block14: {
                Path manifestPath = fs.getPath("/META-INF/MANIFEST.MF", new String[0]);
                if (!Files.exists(manifestPath, new LinkOption[0])) {
                    boolean bl2 = false;
                    return bl2;
                }
                InputStream inputStream = Files.newInputStream(manifestPath, new OpenOption[0]);
                try {
                    Manifest manifest = new Manifest(inputStream);
                    Attributes mainAttributes = manifest.getMainAttributes();
                    bl = "static".equalsIgnoreCase(mainAttributes.getValue("Fabric-Loom-Mixin-Remap-Type"));
                    if (inputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return bl;
        }
    }
}

