/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.minecraft;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ObjectShare;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ApiStatus.Internal
public class ClasspathUtils {
    public static List<Path> getRemapClasspath() throws IOException {
        String remapClasspathFile = System.getProperty("fabric.remapClasspathFile");
        if (remapClasspathFile == null) {
            System.out.println("remapClasspathFile is null! Falling back to ObjectShare.");
            return ClasspathUtils.getClassPathFromObjectShare();
        }
        String content = Files.readString(Path.of(remapClasspathFile, new String[0]));
        return Arrays.stream(content.split(File.pathSeparator)).map(x$0 -> Path.of(x$0, new String[0])).toList();
    }

    @NotNull
    public static List<Path> getClassPathFromObjectShare() {
        ObjectShare share = FabricLoader.getInstance().getObjectShare();
        Object inputs = share.get("fabric-loader:inputGameJars");
        ArrayList<Path> list = new ArrayList<Path>();
        Object oldJar = FabricLoader.getInstance().getObjectShare().get("fabric-loader:inputGameJar");
        List classPaths = FabricLauncherBase.getLauncher().getClassPath();
        if (inputs instanceof List) {
            List inputsList;
            List paths = inputsList = (List)inputs;
            if (oldJar instanceof Path) {
                Path oldJarPath = (Path)oldJar;
                if (((Path)paths.get(0)).toString().equals(oldJarPath.toString())) {
                    list.addAll(paths);
                } else {
                    list.add(oldJarPath);
                }
            } else {
                list.addAll(paths);
            }
        } else if (oldJar instanceof Path) {
            Path oldJarPath = (Path)oldJar;
            list.add(oldJarPath);
        }
        list.addAll(classPaths);
        Optional.ofNullable(share.get("fabric-loader:inputRealmsJar")).filter(Path.class::isInstance).map(Path.class::cast).ifPresent(list::add);
        return list;
    }
}

