/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.resource;

import io.github.fabriccompatibilitylayers.modremappingapi.impl.ModRemappingAPIImpl;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.tree.MappingTree;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.TinyRemapper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.api.TrRemapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ApiStatus.Internal
public class RefmapJson {
    public final Map<String, Map<String, String>> mappings = new HashMap<String, Map<String, String>>();
    public final Map<String, Map<String, Map<String, String>>> data = new HashMap<String, Map<String, Map<String, String>>>();

    public void remap(TinyRemapper tiny) {
        this.data.clear();
        this.mappings.forEach((mixinClass, refmapEntryMap) -> refmapEntryMap.replaceAll((originalName, oldMappedName) -> this.mapRefMapEntry((String)mixinClass, (String)oldMappedName, tiny)));
        this.data.put("named:intermediary", this.mappings);
    }

    public void remap(MappingTree tree, String from, String to) {
        this.data.clear();
        this.mappings.forEach((mixinClass, refmapEntryMap) -> {
            Map<String, String> filteredMap = refmapEntryMap.entrySet().stream().filter(this::filterClass).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            filteredMap.replaceAll((originalName, oldMappedName) -> this.mapRefMapEntry((String)mixinClass, (String)oldMappedName, tree, from, to));
        });
    }

    private boolean filterClass(Map.Entry<String, String> entry) {
        String value = entry.getValue();
        return value != null && value.contains("/") && !value.contains(";") && !value.contains(":") && !value.contains("(");
    }

    private String mapRefMapEntry(String mixinClass, String old, MappingTree tree, String from, String to) {
        int fromId = tree.getNamespaceId(from);
        int toId = tree.getNamespaceId(to);
        return tree.mapClassName(old, fromId, toId);
    }

    private String mapRefMapEntry(String mixinClass, String old, TinyRemapper remapper) {
        try {
            String originalName;
            String quantifier;
            String owner;
            String desc;
            String rest;
            String tail;
            TrRemapper trRemapper = remapper.getEnvironment().getRemapper();
            List<String> supers = ModRemappingAPIImpl.getCurrentContext().getMixinData().getMixin2TargetMap().get(mixinClass);
            String arrow = " -> ";
            int arrowPosition = old.indexOf(arrow);
            if (arrowPosition == -1) {
                tail = "";
                rest = old;
            } else {
                rest = old.substring(0, arrowPosition);
                tail = old.substring(arrowPosition + arrow.length());
            }
            int separatorPosition = rest.indexOf(":");
            if (separatorPosition == -1) {
                int parenthesisPosition = rest.indexOf("(");
                if (parenthesisPosition == -1) {
                    desc = "";
                } else {
                    desc = rest.substring(parenthesisPosition);
                    rest = rest.substring(0, parenthesisPosition);
                }
            } else {
                desc = rest.substring(separatorPosition + 1);
                rest = rest.substring(0, separatorPosition);
            }
            if (rest.startsWith("L")) {
                int endPosition = rest.indexOf(";");
                if (endPosition == -1) {
                    throw new RuntimeException("Cannot parse refmap entry of class " + mixinClass + ": it starts with 'L', and doesn't contain a ';': " + old);
                }
                owner = rest.substring(1, endPosition);
                rest = rest.substring(endPosition + 1);
            } else {
                owner = "";
            }
            int bracesPosition = rest.indexOf("{");
            if (bracesPosition == -1) {
                bracesPosition = rest.indexOf("*");
            }
            if (bracesPosition == -1) {
                bracesPosition = rest.indexOf("+");
            }
            if (bracesPosition == -1) {
                quantifier = "";
            } else {
                quantifier = rest.substring(bracesPosition);
                rest = rest.substring(0, bracesPosition);
            }
            String name = rest;
            if (!quantifier.isEmpty()) {
                throw new RuntimeException("Quantifiers are not yet supported: " + old);
            }
            if (!tail.isEmpty()) {
                throw new RuntimeException("Tails are not yet supported: " + tail);
            }
            if (owner.isEmpty() && desc.isEmpty()) {
                return trRemapper.map(name);
            }
            if (desc.startsWith("(") && desc.contains(")")) {
                if (owner.isEmpty()) {
                    if (supers == null || supers.isEmpty()) {
                        throw new RuntimeException("Can't find target class for mixin " + mixinClass);
                    }
                    originalName = name;
                    String newDesc = trRemapper.mapMethodDesc(desc);
                    if (!originalName.isEmpty()) {
                        for (String own : supers) {
                            name = trRemapper.mapMethodName(own, name, desc);
                            if (originalName.equals(name)) continue;
                            return name + newDesc;
                        }
                    }
                    return originalName + newDesc;
                }
                return "L" + trRemapper.map(owner) + ";" + trRemapper.mapMethodName(owner, name, desc) + trRemapper.mapMethodDesc(desc);
            }
            if (owner.isEmpty()) {
                if (supers == null || supers.isEmpty()) {
                    throw new RuntimeException("Can't find target class for mixin " + mixinClass);
                }
                originalName = name;
                for (String own : supers) {
                    name = trRemapper.mapFieldName(own, name, desc);
                    if (originalName.equals(name)) continue;
                    return name;
                }
                return originalName;
            }
            return "L" + trRemapper.map(owner) + ";" + trRemapper.mapFieldName(owner, name, desc) + (String)(!desc.isEmpty() ? ":" + trRemapper.mapDesc(desc) : "");
        }
        catch (Throwable t) {
            System.err.println("Error while remapping refmap entry: " + old + " for mixin " + mixinClass);
            t.printStackTrace();
            return old;
        }
    }
}

