/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.context;

import fr.catcore.modremapperapi.utils.Constants;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.CacheHandler;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.RemapLibrary;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.TinyRemapper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.utils.FileUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LibraryHandler {
    private Map<RemapLibrary, Path> remapLibraries = new HashMap<RemapLibrary, Path>();
    private String sourceNamespace;
    private CacheHandler cacheHandler;

    public void init(String sourceNamespace, CacheHandler cacheHandler) {
        this.sourceNamespace = sourceNamespace;
        this.cacheHandler = cacheHandler;
        Path sourceLibraryPath = this.cacheHandler.resolveLibrary(this.sourceNamespace);
        if (!Files.exists(sourceLibraryPath, new LinkOption[0])) {
            try {
                Files.createDirectories(sourceLibraryPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Map<RemapLibrary, Path> computeExtraLibraryPaths(Collection<RemapLibrary> sourcePaths, String target) {
        return sourcePaths.stream().collect(Collectors.toMap(p -> p, p -> this.cacheHandler.resolveLibrary(target).resolve(p.getFileName())));
    }

    public void cacheLibraries(List<RemapLibrary> libraries) {
        this.remapLibraries = this.computeExtraLibraryPaths(libraries, this.sourceNamespace);
        try {
            for (Map.Entry<RemapLibrary, Path> entry : this.remapLibraries.entrySet()) {
                RemapLibrary library = entry.getKey();
                Path path = entry.getValue();
                if (Files.exists(path, new LinkOption[0])) continue;
                if (library.getURL() != null && !library.getURL().isEmpty()) {
                    Constants.MAIN_LOGGER.info("Downloading remapping library '%s' from url '%s'", new Object[]{library.getFileName(), library.getURL()});
                    FileUtils.downloadFile(library.getURL(), path);
                    FileUtils.removeEntriesFromZip(path, library.getToExclude());
                    Constants.MAIN_LOGGER.info("Remapping library ready for use.");
                    continue;
                }
                if (library.getPath() == null) continue;
                Constants.MAIN_LOGGER.info("Extracting remapping library '%s' from mod jar.", new Object[]{library.getFileName()});
                FileUtils.copyZipFile(library.getPath(), path);
                Constants.MAIN_LOGGER.info("Remapping library ready for use.");
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void addLibrariesToRemapClasspath(TinyRemapper remapper) {
        for (Path libPath : this.remapLibraries.values()) {
            if (Files.exists(libPath, new LinkOption[0])) {
                remapper.readClassPathAsync(libPath);
                continue;
            }
            Constants.MAIN_LOGGER.info("Library %s does not exist.", new Object[]{libPath});
        }
    }
}

