/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.context;

import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.ModCandidate;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.ModDiscovererConfig;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.context.InternalCacheHandler;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.mappings.MappingsRegistry;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.utils.FileUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ModDiscoverer {
    private final ModDiscovererConfig config;
    private Path originalDirectory;

    public ModDiscoverer(ModDiscovererConfig config) {
        this.config = config;
    }

    public List<ModCandidate> collect() {
        this.originalDirectory = FabricLoader.getInstance().getGameDir().resolve(this.config.getFolderName());
        if (!Files.isDirectory(this.originalDirectory, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<ModCandidate> candidates = new ArrayList<ModCandidate>();
        try {
            this.searchDir(candidates, this.originalDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return candidates;
    }

    private void searchDir(List<ModCandidate> candidates, Path dir) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                Matcher matcher;
                String name = path.getFileName().toString();
                if (Files.isDirectory(path, new LinkOption[0])) {
                    if (this.config.searchRecursively()) {
                        if (!this.config.getDirectoryFilter().test(name)) continue;
                        this.searchDir(candidates, path);
                        continue;
                    }
                    if (!this.config.allowDirectoryMods()) continue;
                    this.discoverMods(candidates, path);
                    continue;
                }
                if (!Files.exists(path, new LinkOption[0]) || !(matcher = this.config.getFileNameMatcher().matcher(name)).matches()) continue;
                this.discoverMods(candidates, path);
            }
        }
    }

    private void discoverMods(List<ModCandidate> candidates, Path modPath) throws IOException {
        List<String> entries = FileUtils.listPathContent(modPath);
        candidates.addAll(this.config.getCandidateCollector().collect(this.config, modPath, entries));
    }

    public void excludeClassEdits(List<ModCandidate> candidates, InternalCacheHandler cacheHandler, MappingsRegistry registry) throws IOException, URISyntaxException {
        Path tempDirectory = cacheHandler.resolveTemp(this.config.getFolderName());
        if (!Files.exists(tempDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(tempDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create temp directory", e);
            }
        } else {
            FileUtils.emptyDir(tempDirectory);
        }
        for (ModCandidate candidate : candidates) {
            Path modPath = candidate.getPath();
            String outputName = candidate.getDestinationName();
            Path outputPath = tempDirectory.resolve(outputName);
            if (Files.isDirectory(modPath, new LinkOption[0])) {
                FileUtils.zipFolder(modPath, outputPath);
            } else {
                Files.copy(modPath, outputPath, new CopyOption[0]);
            }
            FileUtils.removeEntriesFromZip(outputPath, registry.getVanillaClassNames());
            candidate.setPath(outputPath);
        }
    }

    public Map<ModCandidate, Path> computeDestinations(List<ModCandidate> candidates, InternalCacheHandler cacheHandler) {
        Path destination = this.config.getExportToOriginalFolder() ? this.originalDirectory : cacheHandler.resolveCache(this.config.getFolderName());
        if (!Files.exists(destination, new LinkOption[0])) {
            try {
                Files.createDirectories(destination, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create destination directory", e);
            }
        } else if (!this.config.getExportToOriginalFolder()) {
            FileUtils.emptyDir(destination);
        }
        Path finalDestination = destination;
        return candidates.stream().collect(Collectors.toMap(candidate -> candidate, candidate -> {
            Path modDestination = finalDestination.resolve(candidate.getDestinationName());
            candidate.setDestination(modDestination);
            if (Files.exists(modDestination, new LinkOption[0])) {
                try {
                    Files.delete(modDestination);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to delete existing mod destination", e);
                }
            }
            return modDestination;
        }));
    }
}

