/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.context;

import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.MappingBuilder;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.MappedElementKind;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.tree.MemoryMappingTree;
import java.util.Arrays;
import java.util.Objects;
import mod-remapping-api.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={ClassMappingImpl.class})
@ApiStatus.Internal
public class V2MappingBuilderImpl
implements MappingBuilder {
    private final MemoryMappingTree next;

    public V2MappingBuilderImpl(MemoryMappingTree next) {
        this.next = next;
    }

    @Override
    public MappingBuilder.ClassMapping addMapping(String sourceName, String targetName) {
        this.next.visitClass(sourceName);
        this.next.visitDstName(MappedElementKind.CLASS, 0, targetName);
        return new ClassMappingImpl(sourceName, targetName, this.next);
    }

    @Override
    public MappingBuilder.ClassMapping addMapping(String name) {
        this.next.visitClass(name);
        return new ClassMappingImpl(name, null, this.next);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @RecordComponents(value={@RecordComponents.Value(name="sourceName", type=String.class), @RecordComponents.Value(name="targetName", type=String.class), @RecordComponents.Value(name="next", type=MemoryMappingTree.class)})
    @NestHost(value=V2MappingBuilderImpl.class)
    private static final class ClassMappingImpl
    extends J_L_Record
    implements MappingBuilder.ClassMapping {
        private final String sourceName;
        @Nullable
        private final String targetName;
        private final MemoryMappingTree next;

        ClassMappingImpl(String sourceName, @Nullable String targetName, MemoryMappingTree next) {
            this.sourceName = sourceName;
            this.targetName = targetName;
            this.next = next;
        }

        private void visit() {
            this.next.visitClass(this.sourceName);
            if (this.targetName != null) {
                this.next.visitDstName(MappedElementKind.CLASS, 0, this.targetName);
            }
        }

        @Override
        public MappingBuilder.ClassMapping field(String sourceName, String targetName, String sourceDescriptor) {
            this.visit();
            this.next.visitField(sourceName, sourceDescriptor);
            if (targetName != null) {
                this.next.visitDstName(MappedElementKind.FIELD, 0, targetName);
            }
            return this;
        }

        @Override
        public MappingBuilder.ClassMapping field(String name, String descriptor) {
            return this.field(name, null, descriptor);
        }

        @Override
        public MappingBuilder.ClassMapping method(String sourceName, String targetName, String sourceDescriptor) {
            this.visit();
            this.next.visitMethod(sourceName, sourceDescriptor);
            if (targetName != null) {
                this.next.visitDstName(MappedElementKind.METHOD, 0, targetName);
            }
            return this;
        }

        @Override
        public MappingBuilder.ClassMapping method(String name, String descriptor) {
            return this.method(name, null, descriptor);
        }

        @Override
        public final String toString() {
            return ClassMappingImpl.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return ClassMappingImpl.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return ClassMappingImpl.jvmdowngrader$equals$equals(this, o);
        }

        public String sourceName() {
            return this.sourceName;
        }

        @Nullable
        public String targetName() {
            return this.targetName;
        }

        public MemoryMappingTree next() {
            return this.next;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(ClassMappingImpl classMappingImpl) {
            ClassMappingImpl classMappingImpl2 = classMappingImpl;
            return "V2MappingBuilderImpl$ClassMappingImpl[" + "sourceName=" + classMappingImpl.sourceName + ", " + "targetName=" + classMappingImpl.targetName + ", " + "next=" + classMappingImpl.next + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(ClassMappingImpl classMappingImpl) {
            Object[] objectArray = new Object[]{classMappingImpl.sourceName, classMappingImpl.targetName, classMappingImpl.next};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(ClassMappingImpl classMappingImpl, Object object) {
            if (classMappingImpl == object) {
                return true;
            }
            if (object != null && object instanceof ClassMappingImpl) {
                ClassMappingImpl classMappingImpl2 = (ClassMappingImpl)object;
                if (Objects.equals(classMappingImpl.sourceName, classMappingImpl2.sourceName) && Objects.equals(classMappingImpl.targetName, classMappingImpl2.targetName) && Objects.equals(classMappingImpl.next, classMappingImpl2.next)) {
                    return true;
                }
            }
            return false;
        }
    }
}

