/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.accesswidener;

import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.accesswidener.AccessWidener;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.accesswidener.EntryTriple;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;

public final class AccessWidenerClassVisitor
extends ClassVisitor {
    private final AccessWidener accessWidener;
    private String className;
    private int classAccess;

    AccessWidenerClassVisitor(int api, ClassVisitor classVisitor, AccessWidener accessWidener) {
        super(api, classVisitor);
        this.accessWidener = accessWidener;
    }

    public static ClassVisitor createClassVisitor(int api, ClassVisitor visitor, AccessWidener accessWidener) {
        return new AccessWidenerClassVisitor(api, visitor, accessWidener);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.classAccess = access;
        super.visit(version, this.accessWidener.getClassAccess(name).apply(access, name, this.classAccess), name, signature, superName, interfaces);
    }

    public void visitPermittedSubclass(String permittedSubclass) {
        AccessWidener.Access access = this.accessWidener.getClassAccess(this.className);
        if (access == AccessWidener.ClassAccess.EXTENDABLE || access == AccessWidener.ClassAccess.ACCESSIBLE_EXTENDABLE) {
            return;
        }
        super.visitPermittedSubclass(permittedSubclass);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, this.accessWidener.getClassAccess(name).apply(access, name, this.classAccess));
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        return super.visitField(this.accessWidener.getFieldAccess(new EntryTriple(this.className, name, descriptor)).apply(access, name, this.classAccess), name, descriptor, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        return new AccessWidenerMethodVisitor(super.visitMethod(this.accessWidener.getMethodAccess(new EntryTriple(this.className, name, descriptor)).apply(access, name, this.classAccess), name, descriptor, signature, exceptions));
    }

    private class AccessWidenerMethodVisitor
    extends MethodVisitor {
        AccessWidenerMethodVisitor(MethodVisitor methodVisitor) {
            super(AccessWidenerClassVisitor.this.api, methodVisitor);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (opcode == 183 && this.isTargetMethod(owner, name, descriptor)) {
                opcode = 182;
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            for (int i = 0; i < bootstrapMethodArguments.length; ++i) {
                Handle handle;
                if (!(bootstrapMethodArguments[i] instanceof Handle) || (handle = (Handle)bootstrapMethodArguments[i]).getTag() != 7 || !this.isTargetMethod(handle.getOwner(), handle.getName(), handle.getDesc())) continue;
                bootstrapMethodArguments[i] = new Handle(5, handle.getOwner(), handle.getName(), handle.getDesc(), handle.isInterface());
            }
            super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
        }

        private boolean isTargetMethod(String owner, String name, String descriptor) {
            return owner.equals(AccessWidenerClassVisitor.this.className) && !name.equals("<init>") && AccessWidenerClassVisitor.this.accessWidener.getMethodAccess(new EntryTriple(owner, name, descriptor)) != AccessWidener.MethodAccess.DEFAULT;
        }
    }
}

