/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.mappingio.format.tiny;

import java.io.IOException;
import java.io.Writer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class Tiny2Util {
    private static final String toEscape = "\\\n\r\u0000\t";
    private static final String escaped = "\\nr0t";
    static final String escapedNamesProperty = "escaped-names";

    private Tiny2Util() {
    }

    public static boolean needEscape(String s) {
        int len = s.length();
        for (int pos = 0; pos < len; ++pos) {
            char c = s.charAt(pos);
            if (toEscape.indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }

    public static void writeEscaped(String s, Writer out) throws IOException {
        int len = s.length();
        int start = 0;
        for (int pos = 0; pos < len; ++pos) {
            char c = s.charAt(pos);
            int idx = toEscape.indexOf(c);
            if (idx < 0) continue;
            out.write(s, start, pos - start);
            out.write(92);
            out.write(escaped.charAt(idx));
            start = pos + 1;
        }
        out.write(s, start, len - start);
    }

    public static String unescape(String str) {
        int pos = str.indexOf(92);
        if (pos < 0) {
            return str;
        }
        StringBuilder ret = new StringBuilder(str.length() - 1);
        int start = 0;
        do {
            ret.append(str, start, pos);
            if (++pos >= str.length()) {
                throw new RuntimeException("incomplete escape sequence at the end");
            }
            int type = escaped.indexOf(str.charAt(pos));
            if (type < 0) {
                throw new RuntimeException("invalid escape character: \\" + str.charAt(pos));
            }
            ret.append(toEscape.charAt(type));
        } while ((pos = str.indexOf(92, start = pos + 1)) >= 0);
        ret.append(str, start, str.length());
        return ret.toString();
    }
}

