/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.minecraft;

import fr.catcore.modremapperapi.utils.Constants;
import io.github.fabriccompatibilitylayers.modremappingapi.api.v2.CacheHandler;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.NonClassCopyMode;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.OutputConsumerPath;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.lib.tinyremapper.TinyRemapper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.mappings.MappingTreeHelper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.mappings.MappingsRegistry;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.TrRemapperHelper;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.remapper.minecraft.ClasspathUtils;
import io.github.fabriccompatibilitylayers.modremappingapi.impl.utils.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MinecraftRemapper {
    private static Map<Path, Path> computeLibraryPaths(Collection<Path> sourcePaths, Path basePath) {
        return sourcePaths.stream().collect(Collectors.toMap(path -> path, path -> basePath.resolve(path.getFileName())));
    }

    private static Collection<Path> getMinecraftJar(Collection<Path> sourcePaths, String src, String target, MappingsRegistry mappingsRegistry, CacheHandler cacheHandler) throws IOException {
        Map<Path, Path> paths;
        Path targetFolder = cacheHandler.resolveLibrary(target);
        if (Files.notExists(targetFolder, new LinkOption[0])) {
            Files.createDirectories(targetFolder, new FileAttribute[0]);
        }
        if (FileUtils.exist((paths = MinecraftRemapper.computeLibraryPaths(new HashSet<Path>(sourcePaths), targetFolder)).values())) {
            return paths.values();
        }
        FileUtils.delete(paths.values());
        TinyRemapper.Builder builder = TinyRemapper.newRemapper().renameInvalidLocals(true).ignoreFieldDesc(false).propagatePrivate(true).ignoreConflicts(true).fixPackageAccess(true).withMappings(MappingTreeHelper.createMappingProvider(mappingsRegistry.getFormattedMappings(), src, target));
        TinyRemapper remapper = builder.build();
        Constants.MAIN_LOGGER.info("Remapping minecraft jar from %s to %s!", new Object[]{src, target});
        ArrayList<OutputConsumerPath> outputConsumerPaths = new ArrayList<OutputConsumerPath>();
        ArrayList<OutputConsumerPath.ResourceRemapper> resourceRemappers = new ArrayList<OutputConsumerPath.ResourceRemapper>(NonClassCopyMode.FIX_META_INF.remappers);
        TrRemapperHelper.applyRemapper(remapper, paths, outputConsumerPaths, resourceRemappers, true, src, target);
        Constants.MAIN_LOGGER.info("MC jar remapped successfully!");
        return paths.values();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @ApiStatus.Internal
    public static void addMinecraftJar(TinyRemapper remapper, MappingsRegistry mappingsRegistry, CacheHandler cacheHandler) throws IOException {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            try {
                classPath /* !! */  = MinecraftRemapper.getMinecraftJar(MinecraftRemapper.getMinecraftJar(ClasspathUtils.getRemapClasspath(), mappingsRegistry.getTargetNamespace(), "intermediary", mappingsRegistry, cacheHandler), "intermediary", "official", mappingsRegistry, cacheHandler);
                if (mappingsRegistry.isSourceNamespaceObf()) ** GOTO lbl12
                classPath /* !! */  = MinecraftRemapper.getMinecraftJar(classPath /* !! */ , "official", mappingsRegistry.getSourceNamespace(), mappingsRegistry, cacheHandler);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to populate default remap classpath", e);
            }
        } else {
            classPath /* !! */  = ClasspathUtils.getClassPathFromObjectShare();
            if (!mappingsRegistry.isSourceNamespaceObf()) {
                classPath /* !! */  = MinecraftRemapper.getMinecraftJar(classPath /* !! */ , "official", mappingsRegistry.getSourceNamespace(), mappingsRegistry, cacheHandler);
            }
        }
lbl12:
        // 6 sources

        for (Path path : classPath /* !! */ ) {
            Constants.MAIN_LOGGER.debug("Appending '{}' to remapper classpath", new Object[]{path});
            remapper.readClassPathAsync(new Path[]{path});
        }
    }
}

