/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabriccompatibilitylayers.modremappingapi.impl.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import mod-remapping-api.xyz.wagyourtail.jvmdg.j13.stub.java_base.J_N_F_FileSystems;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={1.class})
@ApiStatus.Internal
public class FileUtils {
    private static final Map<String, String> ZIP_PROPERTIES = FileUtils.jvmdg$inlined$of("create", "false", "encoding", "UTF-8");

    @ApiStatus.Internal
    public static boolean exist(Collection<Path> paths) {
        for (Path path : paths) {
            if (Files.exists(path, new LinkOption[0])) continue;
            return false;
        }
        return true;
    }

    @ApiStatus.Internal
    public static void delete(Collection<Path> paths) {
        for (Path path : paths) {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @ApiStatus.Internal
    public static void downloadFile(String url, Path target) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new URL(url).openStream());
             BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(target, new OpenOption[0]));){
            int length;
            byte[] buffer = new byte[2048];
            int downloaded = 0;
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
                downloaded += length;
            }
        }
    }

    @ApiStatus.Internal
    public static void copyZipFile(Path original, Path target) throws IOException {
        Files.deleteIfExists(target);
        try (ZipInputStream zin = new ZipInputStream(Files.newInputStream(original, new OpenOption[0]));
             ZipOutputStream zout = new ZipOutputStream(Files.newOutputStream(target, new OpenOption[0]));){
            ZipEntry entry;
            byte[] buf = new byte[1024];
            while ((entry = zin.getNextEntry()) != null) {
                int len;
                String zipEntryName = entry.getName();
                zout.putNextEntry(new ZipEntry(zipEntryName));
                while ((len = zin.read(buf)) > 0) {
                    zout.write(buf, 0, len);
                }
            }
        }
    }

    @ApiStatus.Internal
    public static List<String> listZipContent(Path path) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        try (ZipInputStream zin = new ZipInputStream(Files.newInputStream(path, new OpenOption[0]));){
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                files.add(entry.getName().replace("\\", "/"));
            }
        }
        return files;
    }

    @ApiStatus.Internal
    public static List<String> listDirectoryContent(File[] files) {
        ArrayList<String> list = new ArrayList<String>();
        for (File file : files) {
            if (file.isDirectory()) {
                String name = file.getName();
                for (String fileName : FileUtils.listDirectoryContent(file.listFiles())) {
                    list.add(FileUtils.jvmdowngrader$concat$listDirectoryContent$1(name, fileName));
                }
                continue;
            }
            if (!file.isFile()) continue;
            list.add(file.getName());
        }
        return list;
    }

    @ApiStatus.Internal
    public static List<String> listPathContent(Path path) throws IOException {
        File file = path.toFile();
        if (file.isDirectory()) {
            return FileUtils.listDirectoryContent(file.listFiles());
        }
        if (file.isFile()) {
            return FileUtils.listZipContent(path);
        }
        return new ArrayList<String>();
    }

    @ApiStatus.Internal
    public static void emptyDir(final Path dir) {
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                @NotNull
                public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                @NotNull
                public FileVisitResult postVisitDirectory(@NotNull Path subDir, IOException exc) throws IOException {
                    if (!dir.equals(subDir)) {
                        Files.delete(subDir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @ApiStatus.Internal
    public static void zipFolder(Path input, Path output) throws IOException {
        try (ZipOutputStream zout = new ZipOutputStream(Files.newOutputStream(output, new OpenOption[0]));){
            File fileToZip = input.toFile();
            FileUtils.zipFile(fileToZip, fileToZip.getName(), zout, true);
        }
    }

    private static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut, boolean root) throws IOException {
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            if (!root) {
                if (fileName.endsWith("/")) {
                    zipOut.putNextEntry(new ZipEntry(fileName));
                    zipOut.closeEntry();
                } else {
                    zipOut.putNextEntry(new ZipEntry(FileUtils.jvmdowngrader$concat$zipFile$1(fileName)));
                    zipOut.closeEntry();
                }
            }
            if ((children = fileToZip.listFiles()) != null) {
                for (File childFile : children) {
                    FileUtils.zipFile(childFile, FileUtils.jvmdowngrader$concat$zipFile$1(root ? "" : FileUtils.jvmdowngrader$concat$zipFile$1(fileName), childFile.getName()), zipOut, false);
                }
            }
            return;
        }
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        try (InputStream fis = Files.newInputStream(fileToZip.toPath(), new OpenOption[0]);){
            int length;
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zipOut.write(bytes, 0, length);
            }
        }
        zipOut.closeEntry();
    }

    @ApiStatus.Internal
    public static FileSystem getJarFileSystem(Path path) throws IOException {
        return J_N_F_FileSystems.newFileSystem(path, ZIP_PROPERTIES);
    }

    @ApiStatus.Internal
    public static void removeEntriesFromZip(Path zipPath, List<String> entries) throws IOException, URISyntaxException {
        try (FileSystem zipfs = FileUtils.getJarFileSystem(zipPath);){
            for (String entryName : entries) {
                Path entryPath = zipfs.getPath(entryName, new String[0]);
                if (!Files.exists(entryPath, new LinkOption[0])) continue;
                Files.delete(entryPath);
            }
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$listDirectoryContent$1(String string, String string2) {
        return string + "/" + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$zipFile$1(String string) {
        return string + "/";
    }

    private static /* synthetic */ String jvmdowngrader$concat$zipFile$1(String string, String string2) {
        return string + string2;
    }

    @Stub(ref=@Ref(value="Ljava/util/Map;"))
    private static /* synthetic */ <K, V> Map<K, V> jvmdg$inlined$of(K k1, V v1, K k2, V v2) {
        HashMap<K, V> map = new HashMap<K, V>(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return Collections.unmodifiableMap(map);
    }
}

