/*
 * Decompiled with CFR 0.152.
 */
package net.countered.smoothf5.mixin;

import net.countered.smoothf5.mixin.CameraAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public class CameraMixin {
    private Vec3 smoothPos = Vec3.ZERO;
    private Vec3 smoothVel = Vec3.ZERO;
    private float smoothYaw;
    private float smoothPitch;
    private float yawVel;
    private float pitchVel;
    private static final float POS_STIFFNESS = 0.3f;
    private static final float POS_DAMPING = 1.0f;
    private static final float ROT_STIFFNESS = 0.7f;
    private static final float ROT_DAMPING = 1.3f;
    @Unique
    private boolean initialized = false;

    @Inject(method={"setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"}, at={@At(value="TAIL")})
    private void onSetup(BlockGetter level, Entity entity, boolean detached, boolean thirdPersonReverse, float partialTick, CallbackInfo ci) {
        Camera self = (Camera)this;
        CameraAccessor acc = (CameraAccessor)self;
        if (!this.initialized) {
            this.smoothPos = self.getPosition();
            this.initialized = true;
            return;
        }
        if (!detached) {
            this.smoothPos = acc.getPosition();
            this.smoothYaw = acc.getYRot();
            this.smoothPitch = acc.getXRot();
            this.smoothVel = Vec3.ZERO;
            this.pitchVel = 0.0f;
            this.yawVel = 0.0f;
            return;
        }
        Vec3 targetPos = acc.getPosition();
        float targetYaw = acc.getYRot();
        float targetPitch = acc.getXRot();
        float dt = Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
        Vec3 diff = targetPos.subtract(this.smoothPos);
        this.smoothVel = this.smoothVel.add(diff.scale((double)(0.3f * dt)));
        this.smoothVel = this.smoothVel.scale((double)((float)Math.exp(-1.0f * dt)));
        this.smoothPos = this.smoothPos.add(this.smoothVel.multiply((double)dt, (double)dt, (double)dt));
        float yawDiff = targetYaw - this.smoothYaw;
        float pitchDiff = targetPitch - this.smoothPitch;
        this.yawVel += yawDiff * 0.7f * dt;
        this.pitchVel += pitchDiff * 0.7f * dt;
        this.yawVel *= (float)Math.exp(-1.3f * dt);
        this.pitchVel *= (float)Math.exp(-1.3f * dt);
        this.smoothYaw += this.yawVel * dt;
        this.smoothPitch += this.pitchVel * dt;
        acc.callSetPosition(this.smoothPos);
        acc.setYRot(this.smoothYaw);
        acc.setXRot(this.smoothPitch);
        Quaternionf q = new Quaternionf().rotationYXZ((float)Math.PI - this.smoothYaw * ((float)Math.PI / 180), -this.smoothPitch * ((float)Math.PI / 180), 0.0f);
        acc.callSetRotation(this.smoothYaw, this.smoothPitch);
    }
}

