/*
 * Decompiled with CFR 0.152.
 */
package net.countered.smoothf5.mixin;

import net.countered.smoothf5.mixin.CameraAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public class CameraMixin {
    private Vec3 smoothPos = Vec3.f_82478_;
    private Vec3 smoothVel = Vec3.f_82478_;
    private float smoothYaw;
    private float smoothPitch;
    private float yawVel;
    private float pitchVel;
    private static final float STIFFNESS = 0.1f;
    private static final float DAMPING = 0.55f;
    @Unique
    private boolean initialized = false;

    @Inject(method={"setup"}, at={@At(value="TAIL")})
    private void onSetup(BlockGetter level, Entity entity, boolean detached, boolean thirdPersonReverse, float partialTick, CallbackInfo ci) {
        Camera self = (Camera)this;
        CameraAccessor acc = (CameraAccessor)self;
        if (!this.initialized) {
            this.smoothPos = self.m_90583_();
            this.initialized = true;
            return;
        }
        if (!detached) {
            this.smoothPos = acc.getPosition();
            this.smoothYaw = acc.getYRot();
            this.smoothPitch = acc.getXRot();
            this.smoothVel = Vec3.f_82478_;
            this.pitchVel = 0.0f;
            this.yawVel = 0.0f;
            return;
        }
        Vec3 targetPos = acc.getPosition();
        float targetYaw = acc.getYRot();
        float targetPitch = acc.getXRot();
        float dt = Minecraft.m_91087_().m_91297_();
        Vec3 diff = targetPos.m_82546_(this.smoothPos);
        this.smoothVel = this.smoothVel.m_82549_(diff.m_82490_((double)(0.1f * dt)));
        this.smoothVel = this.smoothVel.m_82490_((double)((float)Math.exp(-0.55f * dt)));
        this.smoothPos = this.smoothPos.m_82549_(this.smoothVel.m_82542_((double)dt, (double)dt, (double)dt));
        float yawDiff = targetYaw - this.smoothYaw;
        float pitchDiff = targetPitch - this.smoothPitch;
        this.yawVel += yawDiff * 0.1f * dt;
        this.pitchVel += pitchDiff * 0.1f * dt;
        this.yawVel *= (float)Math.exp(-0.55f * dt);
        this.pitchVel *= (float)Math.exp(-0.55f * dt);
        this.smoothYaw += this.yawVel * dt;
        this.smoothPitch += this.pitchVel * dt;
        acc.callSetPosition(this.smoothPos);
        acc.setYRot(this.smoothYaw);
        acc.setXRot(this.smoothPitch);
    }
}

