/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common;

import me.ichun.mods.ichunutil.common.core.Logger;
import me.ichun.mods.ichunutil.common.core.config.ConfigBase;
import me.ichun.mods.ichunutil.common.core.config.ConfigHandler;
import me.ichun.mods.ichunutil.common.core.network.PacketChannel;
import me.ichun.mods.ichunutil.common.module.update.UpdateChecker;
import me.ichun.mods.morph.client.core.EventHandlerClient;
import me.ichun.mods.morph.common.command.CommandMorph;
import me.ichun.mods.morph.common.core.Config;
import me.ichun.mods.morph.common.core.EventHandlerServer;
import me.ichun.mods.morph.common.core.ProxyCommon;
import me.ichun.mods.morph.common.handler.NBTHandler;
import me.ichun.mods.morph.common.handler.PlayerMorphHandler;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;

@Mod(modid="morphtweaked", name="MorphTweaked", version="7.2.0", certificateFingerprint="4db5c2bd1b556f252a5b8b54b256d381b2a0a6b8", guiFactory="me.ichun.mods.ichunutil.common.core.config.GenericModGuiFactory", dependencies="required-after:ichunutil@[7.2.0,8.0.0)", acceptableRemoteVersions="[7.2.0,7.3.0)", acceptedMinecraftVersions="[1.12,1.13)")
public class Morph {
    public static final String VERSION = "7.2.0";
    public static final String MOD_NAME = "MorphTweaked";
    public static final String MOD_ID = "morphtweaked";
    @Mod.Instance(value="morphtweaked")
    public static Morph instance;
    @SidedProxy(clientSide="me.ichun.mods.morph.client.core.ProxyClient", serverSide="me.ichun.mods.morph.common.core.ProxyCommon")
    public static ProxyCommon proxy;
    public static final Logger LOGGER;
    public static EventHandlerServer eventHandlerServer;
    public static EventHandlerClient eventHandlerClient;
    public static PacketChannel channel;
    public static Config config;
    public static SoundEvent soundMorph;
    public static String CANMORPH_TAG_NAME;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = (Config)ConfigHandler.registerConfig((ConfigBase)new Config(event.getSuggestedConfigurationFile()));
        proxy.preInit();
        UpdateChecker.registerMod((UpdateChecker.ModVersionInfo)new UpdateChecker.ModVersionInfo(MOD_NAME, "1.12.2", VERSION, false));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerAboutToStartEvent event) {
        ICommandManager manager = event.getServer().func_71187_D();
        if (manager instanceof CommandHandler) {
            CommandHandler handler = (CommandHandler)manager;
            handler.func_71560_a((ICommand)new CommandMorph());
        }
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        Morph.eventHandlerServer.morphsActive.clear();
        Morph.eventHandlerServer.playerMorphs.clear();
    }

    @Mod.EventHandler
    public void onIMCMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message.key.equalsIgnoreCase("blacklist") && message.isStringMessage()) {
                try {
                    Class<?> clz = Class.forName(message.getStringValue());
                    if (EntityLivingBase.class.isAssignableFrom(clz) && !PlayerMorphHandler.blacklistedEntityClasses.contains(clz)) {
                        PlayerMorphHandler.blacklistedEntityClasses.add(clz);
                        LOGGER.info((Object)("Registered " + message.getStringValue() + " to Morph Entity blacklist"));
                        continue;
                    }
                    LOGGER.info((Object)("Error adding " + message.getStringValue() + " to Morph Entity blacklist. Entity may already be in blacklist or may not be an EntityLivingBase!"));
                }
                catch (ClassNotFoundException e) {
                    LOGGER.info((Object)("Error adding " + message.getStringValue() + " to Morph Entity blacklist. Class not found!"));
                    e.printStackTrace();
                }
                continue;
            }
            if (!message.key.equalsIgnoreCase("nbt_modifier") || !message.isStringMessage()) continue;
            String[] split = message.getStringValue().split(">");
            if (split.length != 3) {
                LOGGER.info((Object)("Error adding NBT modifier for class " + message.getStringValue() + ". Invalid argument count!"));
                continue;
            }
            try {
                Class<?> clz = Class.forName(split[0]);
                if (EntityLivingBase.class.isAssignableFrom(clz)) {
                    NBTHandler.TagModifier tagModifier = NBTHandler.modModifiers.computeIfAbsent(clz, k -> new NBTHandler.TagModifier());
                    NBTHandler.handleModifier(tagModifier, split[1], split[2]);
                    NBTHandler.modModifiers.put(clz, tagModifier);
                    LOGGER.info((Object)("Registered " + message.getStringValue() + " to mod NBT modifiers"));
                    continue;
                }
                LOGGER.info((Object)("Error adding " + message.getStringValue() + " to Morph Entity blacklist. Entity is not an EntityLivingBase!"));
            }
            catch (ClassNotFoundException e) {
                LOGGER.info((Object)("Error adding NBT modifier for class " + message.getStringValue() + ". Class not found!"));
                e.printStackTrace();
            }
        }
    }

    static {
        LOGGER = Logger.createLogger((String)MOD_NAME);
        CANMORPH_TAG_NAME = "morphtweaked:canmorph";
    }
}

