/*
 * Decompiled with CFR 0.152.
 */
package me.elephant1214.unlimitedenchant;

import java.util.Set;
import me.elephant1214.unlimitedenchant.UnlimitedEnchant;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class Util {
    private static final Set<Material> ANVIL_TYPES = Set.of(Material.ANVIL, Material.CHIPPED_ANVIL, Material.DAMAGED_ANVIL);
    public static final NamespacedKey IMMOVABLE_KEY = new NamespacedKey((Plugin)UnlimitedEnchant.getInstance(), "immovable");

    public static boolean isAnvil(@NotNull Block block) {
        return ANVIL_TYPES.contains(block.getType());
    }

    public static ItemStack makeImmovable(@NotNull ItemStack stack) {
        stack.editPersistentDataContainer(pdc -> pdc.set(IMMOVABLE_KEY, PersistentDataType.BOOLEAN, (Object)true));
        return stack;
    }

    public static boolean isImmovable(@NotNull ItemStack stack) {
        return Boolean.TRUE.equals(stack.getPersistentDataContainer().get(IMMOVABLE_KEY, PersistentDataType.BOOLEAN));
    }

    public static String asKey(@NotNull Enchantment enchantment) {
        return enchantment.key().key().asMinimalString();
    }
}

