/*
 * Decompiled with CFR 0.152.
 */
package me.elephant1214.unlimitedenchant.blacklist;

import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import java.util.Map;
import java.util.function.Consumer;
import me.elephant1214.unlimitedenchant.blacklist.BlacklistManager;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public final class BlacklistListeners
implements Listener {
    private final BlacklistManager manager;

    BlacklistListeners(BlacklistManager manager) {
        this.manager = manager;
    }

    private boolean removeBlacklisted(@NotNull Map<Enchantment, Integer> enchants, @NotNull Consumer<Enchantment> remover) {
        boolean anyRemoved = false;
        for (Enchantment enchantment : enchants.keySet()) {
            if (!this.manager.blacklistedEnchants.contains(enchantment)) continue;
            remover.accept(enchantment);
            anyRemoved = true;
        }
        return anyRemoved;
    }

    private boolean handleBook(@NotNull ItemStack stack) {
        EnchantmentStorageMeta storage;
        ItemMeta itemMeta = stack.getItemMeta();
        if (!(itemMeta instanceof EnchantmentStorageMeta) || !(storage = (EnchantmentStorageMeta)itemMeta).hasStoredEnchants()) {
            return false;
        }
        boolean modified = this.removeBlacklisted(storage.getStoredEnchants(), arg_0 -> ((EnchantmentStorageMeta)storage).removeStoredEnchant(arg_0));
        if (storage.getStoredEnchants().isEmpty()) {
            return true;
        }
        if (modified) {
            stack.setItemMeta((ItemMeta)storage);
        }
        return false;
    }

    private boolean removeBlacklisted(@NotNull ItemStack stack) {
        return this.removeBlacklisted(stack.getEnchantments(), arg_0 -> ((ItemStack)stack).removeEnchantment(arg_0));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemClicked(InventoryClickEvent event) {
        if (!this.manager.isEnabled()) {
            return;
        }
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null || event.getClickedInventory() == null) {
            return;
        }
        if (currentItem.getType() == Material.ENCHANTED_BOOK) {
            if (this.handleBook(currentItem)) {
                event.getClickedInventory().remove(currentItem);
            }
            return;
        }
        this.removeBlacklisted(currentItem);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemPickup(EntityPickupItemEvent event) {
        if (!this.manager.isEnabled()) {
            return;
        }
        ItemStack pickedUp = event.getItem().getItemStack();
        if (pickedUp.getType() == Material.ENCHANTED_BOOK) {
            if (this.handleBook(pickedUp)) {
                event.getItem().remove();
                event.setCancelled(true);
            }
            return;
        }
        if (pickedUp.getEnchantments().isEmpty()) {
            return;
        }
        this.removeBlacklisted(pickedUp);
    }

    private boolean checkUse(PlayerInventory inventory, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.getType() == Material.ENCHANTED_BOOK) {
            if (this.handleBook(stack)) {
                inventory.remove(stack);
                return true;
            }
            return false;
        }
        return this.removeBlacklisted(stack);
    }

    private void handleSimilar(@NotNull Cancellable event, @NotNull Player player) {
        if (!this.manager.isEnabled()) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack main = inventory.getItemInMainHand();
        ItemStack offhand = inventory.getItemInOffHand();
        if (this.checkUse(inventory, main) || this.checkUse(inventory, offhand)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerAttack(PrePlayerAttackEntityEvent event) {
        this.handleSimilar((Cancellable)event, event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        this.handleSimilar((Cancellable)event, event.getPlayer());
    }
}

