/*
 * Decompiled with CFR 0.152.
 */
package me.elephant1214.unlimitedenchant.bootstrap;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.bootstrap.PluginBootstrap;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.event.RegistryEvents;
import io.papermc.paper.registry.tag.TagKey;
import io.papermc.paper.tag.PostFlattenTagRegistrar;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.elephant1214.unlimitedenchant.UEConstants;
import me.elephant1214.unlimitedenchant.config.UEConfig;
import org.bukkit.enchantments.Enchantment;
import org.jetbrains.annotations.NotNull;

public final class UEBootstrap
implements PluginBootstrap {
    public static UEConfig config;
    private Set<TypedKey<@NotNull Enchantment>> toDisable = new HashSet<TypedKey<Enchantment>>();

    public void bootstrap(@NotNull BootstrapContext ctx) {
        if (!this.initConfig(ctx)) {
            return;
        }
        this.registerEnchantHandlers(ctx);
    }

    private boolean initConfig(@NotNull BootstrapContext ctx) {
        try {
            config = new UEConfig(ctx.getDataDirectory());
            return true;
        }
        catch (IOException e) {
            UEConstants.LOGGER.error("Could not create config", (Throwable)e);
            return false;
        }
    }

    private void registerEnchantHandlers(@NotNull BootstrapContext ctx) {
        ctx.getLifecycleManager().registerEventHandler(RegistryEvents.ENCHANTMENT.entryAdd().newHandler(event -> {
            int maxLevel = config.getOrSetMaxLevel(event.key().key(), ((EnchantmentRegistryEntry.Builder)event.builder()).maxLevel());
            if (maxLevel > 0) {
                ((EnchantmentRegistryEntry.Builder)event.builder()).maxLevel(maxLevel);
            } else {
                this.toDisable.add((TypedKey<Enchantment>)event.key());
            }
        }));
        ctx.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.TAGS.postFlatten(RegistryKey.ENCHANTMENT), event -> {
            @NotNull PostFlattenTagRegistrar registrar = (PostFlattenTagRegistrar)event.registrar();
            for (Map.Entry entry : registrar.getAllTags().entrySet()) {
                HashSet<@NotNull E> values = new HashSet((Collection)entry.getValue());
                if (!values.removeAll(this.toDisable)) continue;
                registrar.setTag((TagKey)entry.getKey(), values);
            }
            this.toDisable = null;
        });
    }
}

