/*
 * Decompiled with CFR 0.152.
 */
package me.elephant1214.unlimitedenchant.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.registry.RegistryKey;
import me.elephant1214.unlimitedenchant.UEConstants;
import me.elephant1214.unlimitedenchant.blacklist.BlacklistManager;
import me.elephant1214.unlimitedenchant.bootstrap.UEBootstrap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.enchantments.Enchantment;

public final class BlacklistCommand {
    public static void addBlacklistTree(BlacklistManager manager, LiteralArgumentBuilder<CommandSourceStack> root) {
        LiteralArgumentBuilder blacklist = Commands.literal((String)"blacklist");
        blacklist.then(Commands.literal((String)"add").then(Commands.argument((String)"enchantment", (ArgumentType)ArgumentTypes.resource((RegistryKey)RegistryKey.ENCHANTMENT)).executes(ctx -> {
            if (!manager.isEnabled()) {
                Message message = (Message)MessageComponentSerializer.message().serialize((Component)Component.text((String)"The enchantment blacklist is disabled"));
                throw new SimpleCommandExceptionType(message).create();
            }
            Enchantment enchantment = (Enchantment)ctx.getArgument("enchantment", Enchantment.class);
            if (manager.contains(enchantment)) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendRichMessage("<prefix> <enchantment> was already blacklisted.", new TagResolver[]{UEConstants.Misc.PLUGIN_PREFIX, Placeholder.component((String)"enchantment", (ComponentLike)enchantment.description())});
                return 1;
            }
            UEBootstrap.config.blacklistEnchantment(enchantment);
            manager.updateBlacklist();
            ((CommandSourceStack)ctx.getSource()).getSender().sendRichMessage("<prefix> Added <enchantment> to the enchantment blacklist.", new TagResolver[]{UEConstants.Misc.PLUGIN_PREFIX, Placeholder.component((String)"enchantment", (ComponentLike)enchantment.description())});
            return 1;
        })));
        blacklist.then(Commands.literal((String)"enable").executes(ctx -> BlacklistCommand.toggleBlacklist(manager, (CommandContext<CommandSourceStack>)ctx, true)));
        blacklist.then(Commands.literal((String)"disable").executes(ctx -> BlacklistCommand.toggleBlacklist(manager, (CommandContext<CommandSourceStack>)ctx, false)));
        root.then((ArgumentBuilder)blacklist);
    }

    private static int toggleBlacklist(BlacklistManager manager, CommandContext<CommandSourceStack> ctx, boolean enable) throws CommandSyntaxException {
        String status;
        String string = status = enable ? "enabled" : "disabled";
        if (enable == UEBootstrap.config.blacklistEnabled()) {
            Message message = (Message)MessageComponentSerializer.message().serialize((Component)Component.text((String)("The enchantment blacklist is already " + status)));
            throw new SimpleCommandExceptionType(message).create();
        }
        UEBootstrap.config.setBlacklist(enable);
        if (enable) {
            manager.enableBlacklist();
        } else {
            manager.disableBlacklist();
        }
        ((CommandSourceStack)ctx.getSource()).getSender().sendRichMessage("<prefix> The enchantment blacklist is now " + status, new TagResolver[]{UEConstants.Misc.PLUGIN_PREFIX});
        return 1;
    }
}

