/*
 * Decompiled with CFR 0.152.
 */
package me.elephant1214.unlimitedenchant.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.elephant1214.unlimitedenchant.UEConstants;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public final class ConfigManager {
    private final Path configPath;
    private YamlConfiguration config;

    public ConfigManager(@NotNull Path folder, @NotNull String name) throws IOException {
        if (Files.notExists(folder, new LinkOption[0])) {
            Files.createDirectory(folder, new FileAttribute[0]);
        }
        this.configPath = folder.resolve(name);
        if (Files.notExists(this.configPath, new LinkOption[0])) {
            Files.createFile(this.configPath, new FileAttribute[0]);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configPath.toFile());
    }

    YamlConfiguration get() {
        return this.config;
    }

    public void save() {
        try {
            this.config.save(this.configPath.toFile());
        }
        catch (IOException e) {
            UEConstants.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configPath.toFile());
    }
}

