/*
 * Decompiled with CFR 0.152.
 */
package me.elephant1214.unlimitedenchant.config;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.elephant1214.unlimitedenchant.UEConstants;
import me.elephant1214.unlimitedenchant.Util;
import me.elephant1214.unlimitedenchant.config.ConfigManager;
import net.kyori.adventure.key.Key;
import org.bukkit.Registry;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;

public final class UEConfig {
    private final ConfigManager manager;

    public UEConfig(@NotNull Path folder) throws IOException {
        this.manager = new ConfigManager(folder, "config.yml");
        this.setDefaults();
    }

    private void setDefaults() {
        YamlConfiguration config = this.manager.get();
        config.addDefault("customMenus.anvil.enabled", (Object)false);
        config.addDefault("customMenus.anvil.maxLevel", (Object)120);
        config.addDefault("customMenus.anvil.separator", (Object)"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNjgyYWQxYjljYjRkZDIxMjU5YzBkNzVhYTMxNWZmMzg5YzNjZWY3NTJiZTM5NDkzMzgxNjRiYWM4NGE5NmUifX19");
        config.addDefault("blacklist.enabled", (Object)false);
        config.addDefault("blacklist.enchantments", List.of("aqua_affinity", "bane_of_arthropods"));
        config.options().copyDefaults(true);
        config.options().setHeader(List.of("This configuration allows you to modify the maximum levels of all registered enchantments.", "A full server restart is required for changes to take effect; therefore, no reload command is provided.", "Note that the effects of some enchantments scale very little with higher levels, and a few have no changes.", "For a complete list of vanilla enchantments and their resource locations, visit:", "https://minecraft.wiki/w/Java_Edition_data_values#Enchantments", "The effects of Channeling, Curse of Binding, Curse of Vanishing, Flame, Infinity, and Silk Touch do not change with increased levels."));
        this.manager.save();
    }

    public boolean customAnvilEnabled() {
        return this.manager.get().getBoolean("customMenus.anvil.enabled");
    }

    public void setCustomAnvil(boolean enabled) {
        this.manager.get().set("customMenus.anvil.enabled", (Object)enabled);
    }

    public int customAnvilMaxLevel() {
        return this.manager.get().getInt("customMenus.anvil.maxLevel");
    }

    public void setAnvilMaxLevel(int level) {
        this.manager.get().set("customMenus.anvil.maxLevel", (Object)level);
    }

    public String customAnvilSeparator() {
        String base64 = this.manager.get().getString("customMenus.anvil.separator");
        try {
            Base64.getDecoder().decode(base64);
        }
        catch (IllegalArgumentException e) {
            UEConstants.LOGGER.error("{} had invalid base64; using the default head icon.", (Object)"customMenus.anvil.separator");
            base64 = this.manager.get().getDefaults().getString("customMenus.anvil.separator");
        }
        return base64;
    }

    public boolean blacklistEnabled() {
        return this.manager.get().getBoolean("blacklist.enabled");
    }

    public void setBlacklist(boolean enabled) {
        this.manager.get().set("blacklist.enabled", (Object)enabled);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Set<Enchantment> blacklistedEnchantments() {
        HashSet<Enchantment> blacklist = new HashSet<Enchantment>();
        if (!this.blacklistEnabled()) {
            return blacklist;
        }
        List unparsed = this.manager.get().getStringList("blacklist.enchantments");
        @NonNull Registry registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT);
        for (String enchant : unparsed) {
            if (!Key.parseable((String)enchant)) {
                UEConstants.LOGGER.error("Unable to parse {} as a registry key, skipping it", (Object)enchant);
                continue;
            }
            Key key = Key.key((String)enchant);
            @Nullable Enchantment enchantment = (Enchantment)registry.get(key);
            if (enchantment == null) {
                UEConstants.LOGGER.error("Ignoring blacklisted enchantment {} as it is not present in the game registry", (Object)key.asMinimalString());
                continue;
            }
            blacklist.add(enchantment);
        }
        return blacklist;
    }

    public void blacklistEnchantment(Enchantment enchantment) {
        YamlConfiguration config = this.manager.get();
        List blacklist = config.getStringList("blacklist.enchantments");
        blacklist.add(Util.asKey(enchantment));
        config.set("blacklist.enchantments", (Object)blacklist);
        this.save();
    }

    public int getOrSetMaxLevel(@NotNull Key enchantment, int def) {
        Integer level;
        String path;
        YamlConfiguration config = this.manager.get();
        Object levelObj = config.get(path = "levels." + enchantment.namespace() + "." + enchantment.value());
        if (levelObj instanceof Integer && (level = (Integer)levelObj) >= 0) {
            return level;
        }
        config.set(path, (Object)def);
        return def;
    }

    public int getMaxLevel(@NotNull Enchantment enchantment) {
        return this.getOrSetMaxLevel(enchantment.key().key(), enchantment.getMaxLevel());
    }

    public void setMaxLevel(@NotNull Key enchantment, int value) {
        String path = "levels." + enchantment.namespace() + "." + enchantment.value();
        this.manager.get().set(path, (Object)value);
        this.save();
    }

    public void reload() {
        this.manager.reload();
    }

    public void save() {
        this.manager.save();
    }
}

