/*
 * Decompiled with CFR 0.152.
 */
package me.elephant1214.unlimitedenchant.gui.anvil;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.papermc.paper.datacomponent.DataComponentTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.elephant1214.unlimitedenchant.UnlimitedEnchant;
import me.elephant1214.unlimitedenchant.Util;
import me.elephant1214.unlimitedenchant.bootstrap.UEBootstrap;
import me.elephant1214.unlimitedenchant.gui.anvil.AnvilOutput;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.Slot;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.view.CraftAnvilView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.inventory.view.builder.LocationInventoryViewBuilder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;

public final class AnvilGui
implements InventoryHolder {
    public static final int ANVIL_SLOT = 8;
    public static final int INPUT1_SLOT = 10;
    public static final int INPUT2_SLOT = 12;
    public static final int SEPARATOR_SLOT = 14;
    public static final int RESULT_SLOT = 16;
    public static final int COST_SLOT = 25;
    private static final int INV_SIZE = 27;
    private static final Set<Integer> INTERACT_SLOTS = Set.of(Integer.valueOf(10), Integer.valueOf(12), Integer.valueOf(16));
    private static final Map<UUID, AnvilGui> ANVILS = Maps.newHashMap();
    private static final ItemStack FILLER_STACK = AnvilGui.makeGuiPart(Material.GRAY_STAINED_GLASS_PANE);
    private static final ItemStack WAITING = AnvilGui.makeSeparator();
    private static final ItemStack INVALID = AnvilGui.makeGuiPart(Material.BARRIER);
    @NotNull
    private final org.bukkit.entity.Player player;
    @NotNull
    private final AnvilView anvilView;
    @NotNull
    private final Block anvil;
    @NotNull
    private final Inventory inv;
    private boolean canTake = false;

    public AnvilGui(@NotNull org.bukkit.entity.Player player, @NotNull Block anvil) {
        this.player = player;
        this.anvilView = AnvilGui.buildAnvilView(player, anvil);
        this.anvil = anvil;
        this.inv = Bukkit.createInventory((InventoryHolder)player, (int)27, (Component)Component.translatable((String)"container.repair"));
    }

    @NotNull
    public static AnvilGui makeMenu(@NotNull org.bukkit.entity.Player player, @NotNull Block anvil) {
        return ANVILS.computeIfAbsent(player.getPlayerProfile().getId(), uuid -> new AnvilGui(player, anvil));
    }

    @Nullable
    public static AnvilGui getMenu(@NotNull org.bukkit.entity.Player player) {
        return ANVILS.get(player.getPlayerProfile().getId());
    }

    private static AnvilView buildAnvilView(@NotNull org.bukkit.entity.Player player, @NotNull Block anvil) {
        return (AnvilView)((LocationInventoryViewBuilder)MenuType.ANVIL.builder()).location(anvil.getLocation()).build((HumanEntity)player);
    }

    private static ItemStack makeGuiPart(@NotNull Material material) {
        ItemStack renameStack = new ItemStack(material, 1);
        ItemMeta meta = renameStack.getItemMeta();
        meta.customName((Component)Component.text((String)""));
        renameStack.setItemMeta(meta);
        Util.makeImmovable(renameStack);
        return renameStack;
    }

    private static ItemStack makeSeparator() {
        ItemStack head = ItemStack.of((Material)Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        PlayerProfile profile = Bukkit.createProfile((UUID)new UUID(0L, 0L), (String)"");
        ProfileProperty textures = new ProfileProperty("textures", UEBootstrap.config.customAnvilSeparator());
        profile.setProperty(textures);
        meta.setPlayerProfile(profile);
        meta.displayName((Component)Component.text((String)""));
        head.setItemMeta((ItemMeta)meta);
        Util.makeImmovable(head);
        return head;
    }

    public void openInventory() {
        this.update();
        this.addAnvilButton();
        this.addFiller();
        this.player.openInventory(this.inv);
    }

    private void setSlots(@NotNull ItemStack separator, @NotNull ItemStack result, @NotNull ItemStack cost) {
        this.inv.setItem(14, separator);
        this.inv.setItem(16, result);
        this.inv.setItem(25, cost);
    }

    public void update() {
        boolean has2;
        ItemStack input1 = this.inv.getItem(10);
        ItemStack input2 = this.inv.getItem(12);
        boolean has1 = input1 != null;
        boolean bl = has2 = input2 != null;
        if (!has1 && !has2) {
            this.setSlots(WAITING, FILLER_STACK, FILLER_STACK);
            this.canTake = false;
            return;
        }
        if (has1 ^ has2) {
            this.setSlots(INVALID, FILLER_STACK, FILLER_STACK);
            this.canTake = false;
            return;
        }
        @Nullable AnvilOutput result = this.getRecipe(input1.clone(), input2.clone());
        if (result == null) {
            this.setSlots(INVALID, FILLER_STACK, FILLER_STACK);
            this.canTake = false;
            return;
        }
        this.canTake = this.player.getLevel() >= result.cost() || this.creativeMode();
        this.setSlots(this.canTake ? WAITING : INVALID, this.canTake ? result.stack() : Util.makeImmovable(result.stack()), this.makeCostStack(result.cost()));
    }

    public boolean canTakeResult() {
        return this.canTake;
    }

    public void onTake() {
        this.inv.setItem(10, null);
        this.inv.setItem(12, null);
        AnvilMenu menu = (AnvilMenu)((CraftAnvilView)this.anvilView).getHandle();
        ((Slot)menu.slots.get(menu.getResultSlot())).onTake((Player)((CraftPlayer)this.player).getHandle(), (net.minecraft.world.item.ItemStack)menu.getItems().get(menu.getResultSlot()));
    }

    private void returnItems() {
        ItemStack input1 = this.inv.getItem(10);
        ItemStack input2 = this.inv.getItem(12);
        ArrayList items = Lists.newArrayList();
        if (input1 != null) {
            items.add(input1);
        }
        if (input2 != null) {
            items.add(input2);
        }
        if (!items.isEmpty()) {
            this.player.give((Collection)items, true);
        }
    }

    public void onClose() {
        ANVILS.remove(this.player.getPlayerProfile().getId());
        Bukkit.getScheduler().runTaskLater((Plugin)UnlimitedEnchant.getInstance(), this::returnItems, 1L);
    }

    @Nullable
    private ItemStack updateAnvil(@Nullable ItemStack input1, @Nullable ItemStack input2) {
        AnvilMenu menu = (AnvilMenu)((CraftAnvilView)this.anvilView).getHandle();
        AnvilInventory anvil = this.anvilView.getTopInventory();
        anvil.setFirstItem(input1);
        anvil.setSecondItem(input2);
        menu.createResult();
        return anvil.getResult();
    }

    @Nullable
    private AnvilOutput getRecipe(ItemStack input1, ItemStack input2) {
        this.anvilView.setMaximumRepairCost(this.bypassLimitPerm() ? 8192 : UEBootstrap.config.customAnvilMaxLevel());
        ItemStack result = this.updateAnvil(input1, input2);
        if (result == null) {
            return null;
        }
        if (input1.getItemMeta().hasDisplayName()) {
            ItemMeta meta = result.getItemMeta();
            meta.displayName(input1.getItemMeta().displayName());
            result.setItemMeta(meta);
        }
        return new AnvilOutput(result, this.anvilView.getRepairCost());
    }

    private ItemStack makeCostStack(int cost) {
        ItemStack stack = ItemStack.of((Material)Material.EXPERIENCE_BOTTLE);
        stack.setData(DataComponentTypes.MAX_STACK_SIZE, (Object)99);
        stack.setAmount(cost);
        ItemMeta meta = stack.getItemMeta();
        if (cost > UEBootstrap.config.customAnvilMaxLevel() && !this.bypassLimitPerm() && !this.creativeMode()) {
            meta.customName(Component.translatable((String)"container.repair.expensive").style(Style.style((TextColor)NamedTextColor.RED)));
        } else {
            meta.customName(Component.translatable((String)"container.repair.cost", (ComponentLike[])new ComponentLike[]{Component.text((int)cost)}).style(Style.style((TextColor)(this.canTake ? NamedTextColor.GREEN : NamedTextColor.RED))));
        }
        stack.setItemMeta(meta);
        Util.makeImmovable(stack);
        return stack;
    }

    public void anvilClicked() {
        this.player.openInventory((InventoryView)AnvilGui.buildAnvilView(this.player, this.anvil));
    }

    private void addAnvilButton() {
        this.inv.setItem(8, Util.makeImmovable(ItemStack.of((Material)Material.ANVIL)));
    }

    private void addFiller() {
        for (int slot = 0; slot < 27; ++slot) {
            if (this.inv.getItem(slot) != null || INTERACT_SLOTS.contains(slot)) continue;
            this.inv.setItem(slot, FILLER_STACK);
        }
    }

    private boolean bypassLimitPerm() {
        return this.player.hasPermission("unlimitedenchant.anvil.bypass");
    }

    private boolean creativeMode() {
        return this.player.getGameMode() == GameMode.CREATIVE;
    }

    public @NonNull Inventory getInventory() {
        return this.inv;
    }
}

