/*
 * Decompiled with CFR 0.152.
 */
package me.elephant1214.unlimitedenchant.gui.anvil;

import java.util.Iterator;
import me.elephant1214.unlimitedenchant.UnlimitedEnchant;
import me.elephant1214.unlimitedenchant.Util;
import me.elephant1214.unlimitedenchant.gui.anvil.AnvilGui;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class AnvilListeners
implements Listener {
    private final UnlimitedEnchant plugin;

    public AnvilListeners(UnlimitedEnchant plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onOpenAnvil(PlayerInteractEvent event) {
        if (event.hasBlock() && Util.isAnvil(event.getClickedBlock())) {
            AnvilGui menu = AnvilGui.makeMenu(event.getPlayer(), event.getClickedBlock());
            menu.openInventory();
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onClickInv(InventoryClickEvent event) {
        boolean immovable;
        AnvilGui holder = AnvilGui.getMenu((Player)event.getView().getPlayer());
        if (holder == null || event.getInventory() != holder.getInventory()) {
            return;
        }
        ItemStack stack = event.getCurrentItem();
        boolean bl = immovable = stack != null && Util.isImmovable(stack);
        if (immovable) {
            event.setCancelled(true);
            if (event.getSlot() == 8) {
                holder.anvilClicked();
            }
        } else if (event.getSlot() == 16 && holder.canTakeResult()) {
            holder.onTake();
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, holder::update, 1L);
    }

    @EventHandler
    public void onInvDrag(InventoryDragEvent event) {
        AnvilGui holder = AnvilGui.getMenu((Player)event.getView().getPlayer());
        if (holder == null || event.getView().getTopInventory() != holder.getInventory()) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            ItemStack stack = event.getView().getItem(slot);
            if (stack == null || !Util.isImmovable(stack)) continue;
            event.setCancelled(true);
            if (slot != 8) break;
            holder.anvilClicked();
            break;
        }
        if (!event.isCancelled() && event.getRawSlots().contains(16) && holder.canTakeResult()) {
            holder.onTake();
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, holder::update, 1L);
    }

    @EventHandler
    public void onInvClose(InventoryCloseEvent event) {
        AnvilGui holder = AnvilGui.getMenu((Player)event.getView().getPlayer());
        if (holder == null || holder.getInventory() != event.getInventory()) {
            return;
        }
        holder.onClose();
    }
}

