/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.config.data;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.data.ConfigData;
import net.bivrik.fancytoasts.client.registry.AnimationRegistry;
import net.bivrik.fancytoasts.client.registry.TextureRegistry;
import net.bivrik.fancytoasts.platform.utility.FancyToastType;
import net.bivrik.fancytoasts.utility.DefaultLocations;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;

public class ToastConfigData
extends ConfigData {
    private class_2960 textureId;
    private class_2960 animationId;
    private final Map<FancyToastType, class_2960> soundIds = new EnumMap<FancyToastType, class_2960>(FancyToastType.class);

    public ToastConfigData(class_2960 textureId, class_2960 animationId, Map<FancyToastType, class_2960> soundIds) {
        super("./config/fancytoasts/toast.json");
        this.textureId = textureId;
        this.animationId = animationId;
        this.soundIds.putAll(soundIds);
    }

    public ToastConfigData() {
        this(DefaultLocations.Textures.VANILLA, DefaultLocations.Animations.STANDARD, Map.of(FancyToastType.TASK, class_3417.field_38365.method_14833(), FancyToastType.GOAL, class_3417.field_14882.method_14833(), FancyToastType.CHALLENGE, class_3417.field_15195.method_14833()));
    }

    public class_2960 getTextureId() {
        if (this.isConfig(this.textureId) && !TextureRegistry.isRegistered(this.textureId)) {
            class_2960 standardTextureId = new ToastConfigData().textureId;
            this.setTextureId(standardTextureId);
            ConfigHandler.save(this.copy());
            return standardTextureId;
        }
        return this.textureId;
    }

    public void setTextureId(class_2960 id) {
        this.textureId = id;
    }

    public class_2960 getAnimationId() {
        return this.animationId;
    }

    public void setAnimationId(class_2960 id) {
        this.animationId = id;
    }

    public class_2960 getSoundIdByType(FancyToastType type) {
        class_2960 soundId;
        Collection availableSounds = class_310.method_1551().method_1483().method_4864();
        if (!availableSounds.contains(soundId = this.soundIds.get((Object)type))) {
            class_2960 standardSoundId = new ToastConfigData().soundIds.get((Object)type);
            this.putSoundIdForType(standardSoundId, type);
            ConfigHandler.save(this.copy());
            return standardSoundId;
        }
        return this.soundIds.get((Object)type);
    }

    public void putSoundIdForType(class_2960 location, FancyToastType type) {
        this.soundIds.put(type, location);
    }

    @Override
    public boolean isValid() {
        boolean isValid = true;
        if (!this.isConfig(this.animationId)) {
            isValid = AnimationRegistry.isRegistered(this.animationId);
        }
        if (!this.isConfig(this.textureId)) {
            isValid = isValid && TextureRegistry.isRegistered(this.textureId);
        }
        return isValid;
    }

    private boolean isConfig(class_2960 id) {
        return id.method_42094().contains("config");
    }

    public boolean equals(Object o) {
        if (!(o instanceof ToastConfigData)) {
            return false;
        }
        ToastConfigData that = (ToastConfigData)o;
        return Objects.equals(this.textureId, that.textureId) && Objects.equals(this.animationId, that.animationId) && Objects.equals(this.soundIds, that.soundIds);
    }

    public int hashCode() {
        return Objects.hash(this.textureId, this.animationId, this.soundIds);
    }

    @Override
    public ToastConfigData copy() {
        return new ToastConfigData(this.textureId, this.animationId, this.soundIds);
    }

    @Override
    public String toString() {
        return super.toString().replace("}", ", ") + String.format("textureId='%s', animationId='%s', soundIds='%s'}", this.textureId, this.animationId, this.soundIds);
    }
}

