/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.bivrik.fancytoasts.core.manager.CreditsManager;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public class CreditsList
extends class_350<Entry> {
    private final List<Entry> lines = new ArrayList<Entry>(10);
    private float autoScrollSpeed = 0.4f;

    public CreditsList(class_310 minecraft, int width, int height, int x, int y, CreditsManager.CreditsData data) {
        super(minecraft, width, height, y, y + height, 18);
        this.field_19088 = x;
        this.field_19087 = x + width;
        this.method_29344(false);
        this.method_31323(false);
        this.method_31322(false);
        this.updateList(data);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.method_51422(0.25f, 0.25f, 0.25f, 1.0f);
        guiGraphics.method_25290(class_437.field_44669, this.field_19088, this.field_19085, (float)this.field_19087, (float)(this.field_19086 + (int)this.method_25341()), this.field_19087 - this.field_19088, this.field_19086 - this.field_19085, 32, 32);
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void updateList(CreditsManager.CreditsData data) {
        for (int i = 0; i < this.field_22743 / this.field_22741 + 2; ++i) {
            this.addSpace();
        }
        for (String category : data.categories().keySet()) {
            this.addCategory(category);
            for (CreditsManager.CreditsData.User user : data.categories().get(category)) {
                this.addLine(user);
            }
            this.addSpace();
        }
        for (int i = 0; i < this.field_22743 / this.field_22741; ++i) {
            this.addSpace();
        }
        this.acceptLines();
    }

    private void acceptLines() {
        for (Entry line : this.lines) {
            this.method_25321(line);
        }
    }

    private void addSpace() {
        this.lines.add(new SpaceEntry(this, ""));
    }

    private void addCategory(String category) {
        this.lines.add(new CategoryEntry(this, category));
    }

    private void addLine(CreditsManager.CreditsData.User user) {
        String content = user.name().compareTo("{user.name}") != 0 ? user.name() : this.field_22740.method_1548().method_1676();
        this.lines.add(new UserEntry(this, content, user.annotation()));
    }

    public void scroll() {
        this.method_25307(this.method_25341() + (double)this.autoScrollSpeed);
        if (this.method_25341() == (double)this.method_25331()) {
            this.method_25307(0.0);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.autoScrollSpeed = 1.2f;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.autoScrollSpeed = 0.4f;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    protected int method_25329() {
        return this.field_22742 * 2;
    }

    public void method_37020(@NotNull class_6382 narrationElementOutput) {
    }

    protected static abstract class Entry
    extends class_350.class_351<Entry> {
        protected final CreditsList parentList;
        protected final String content;
        protected final class_327 font;

        public Entry(CreditsList parentList, String content) {
            this.parentList = parentList;
            this.content = content;
            this.font = ((CreditsList)this.parentList).field_22740.field_1772;
        }

        public void method_25343(@NotNull class_332 guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
        }
    }

    private static class SpaceEntry
    extends Entry {
        public SpaceEntry(CreditsList parentList, String content) {
            super(parentList, content);
        }
    }

    private static class CategoryEntry
    extends Entry {
        private final class_2561 displayName;
        private final int xCenter;

        public CategoryEntry(CreditsList parentList, String content) {
            super(parentList, content);
            this.displayName = Components.of("label." + this.content);
            this.xCenter = parentList.field_22742 / 2;
        }

        @Override
        public void method_25343(@NotNull class_332 guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            guiGraphics.method_27534(this.font, this.displayName, this.xCenter, y, -256);
        }
    }

    private static class UserEntry
    extends Entry {
        private final String annotation;
        private final boolean isValidAnnotation;

        public UserEntry(CreditsList parentList, String content, String annotation) {
            super(parentList, content);
            this.annotation = annotation;
            this.isValidAnnotation = this.annotation != null && !this.annotation.isEmpty();
        }

        @Override
        public void method_25343(@NotNull class_332 guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            guiGraphics.method_25303(this.font, this.content, x, y, -1);
            if (this.isValidAnnotation) {
                guiGraphics.method_25303(this.font, this.annotation, x + this.font.method_1727(this.content) + 8, y, -6250336);
            }
        }
    }
}

