/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.bivrik.fancytoasts.client.gui.ResourceLocationFilter;
import net.bivrik.fancytoasts.client.gui.SettingType;
import net.bivrik.fancytoasts.core.Debug;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.GuiContext;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4280;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import net.minecraft.class_8494;
import org.jetbrains.annotations.NotNull;

public class ResourceLocationList
extends class_4280<Entry> {
    private final Map<class_2960, String> displayNames = new HashMap<class_2960, String>();
    private class_2960[] resourceLocations;
    private SettingType settingType;
    private Consumer<class_2960> selectResponder;
    private Consumer<class_2960> focusResponder;
    private ResourceLocationFilter filter = ResourceLocationFilter.A_Z;
    private String search = "";

    public ResourceLocationList(class_310 minecraft, int width, int height, int x, int y, int itemHeight, SettingType settingType) {
        super(minecraft, width, height, y, y + height, itemHeight);
        this.field_19088 = x;
        this.field_19087 = x + width;
        this.method_29344(true);
        this.setResourceLocations(settingType);
    }

    public int method_25322() {
        return this.field_22742 - 6 - 16;
    }

    public int method_25342() {
        return this.field_19088 + this.field_22742 / 2 - this.method_25322() / 2 - 3;
    }

    protected int method_25329() {
        return this.field_19087 - 8;
    }

    public void setResourceLocations(SettingType settingType) {
        this.settingType = settingType;
        this.resourceLocations = this.settingType.getKeySet();
        this.displayNames.clear();
        for (class_2960 location : this.resourceLocations) {
            this.displayNames.computeIfAbsent(location, location1 -> this.settingType.getDisplayData((class_2960)location1).getDisplayName().getString().toLowerCase(Locale.ROOT));
        }
        this.sortAZ();
        this.refillList();
    }

    private void refillList() {
        this.clearList();
        if (this.search.isEmpty()) {
            for (class_2960 location : this.resourceLocations) {
                this.method_25321((class_350.class_351)new ResourceLocationListEntry(this, location, this.settingType.getDisplayData(location).getDisplayName()));
            }
        } else {
            for (class_2960 location : this.resourceLocations) {
                if (!this.displayNames.get(location).contains(this.search)) continue;
                this.method_25321((class_350.class_351)new ResourceLocationListEntry(this, location, this.settingType.getDisplayData(location).getDisplayName()));
            }
        }
    }

    private void clearList() {
        this.method_25339();
        this.method_25307(0.0);
    }

    public void setSearch(String search) {
        String lowercaseSearch;
        if (search == null) {
            search = "";
        }
        if (this.search.equals(lowercaseSearch = search.toLowerCase(Locale.ROOT))) {
            return;
        }
        this.search = lowercaseSearch;
        this.refillList();
    }

    public void setFilter(ResourceLocationFilter filter) {
        if (this.filter == filter || filter == null) {
            return;
        }
        this.filter = filter;
        this.onFilterUpdate();
    }

    private void onFilterUpdate() {
        switch (this.filter) {
            case A_Z: {
                this.sortAZ();
                break;
            }
            case Z_A: {
                this.sortAZ(Comparator.reverseOrder());
                break;
            }
            case BUILT_IN: {
                this.typeSort(true);
                break;
            }
            case CUSTOM: {
                this.typeSort(false);
            }
        }
        this.refillList();
    }

    private void sortAZ(Comparator<String> comparator) {
        Arrays.sort(this.resourceLocations, (loc1, loc2) -> comparator.compare(this.displayNames.get(loc1), this.displayNames.get(loc2)));
    }

    private void sortAZ() {
        this.sortAZ(Comparator.naturalOrder());
    }

    private void typeSort(boolean isBuiltInFilterType) {
        this.sortAZ();
        ArrayList<Object> builtInLocations = new ArrayList<Object>(this.resourceLocations.length * 2 / 3);
        ArrayList<class_2960> configLocations = new ArrayList<class_2960>();
        for (class_2960 location : this.resourceLocations) {
            String namespace = location.method_12836();
            boolean isBuiltIn = namespace.equals("fancytoasts") || namespace.equals("minecraft");
            boolean isConfig = location.method_12832().contains("config") || !isBuiltIn;
            if (isBuiltInFilterType == !isConfig) {
                builtInLocations.add(location);
                continue;
            }
            configLocations.add(location);
        }
        builtInLocations.addAll(configLocations);
        this.resourceLocations = builtInLocations.toArray(new class_2960[0]);
    }

    public ResourceLocationList setSelectResponder(Consumer<class_2960> selectResponder) {
        this.selectResponder = selectResponder;
        return this;
    }

    public ResourceLocationList setFocusResponder(Consumer<class_2960> focusResponder) {
        this.focusResponder = focusResponder;
        return this;
    }

    private static final class ResourceLocationListEntry
    extends Entry {
        private final ResourceLocationList parentList;
        private final class_2960 id;
        private final boolean isConfig;
        private final class_327 font;
        private final class_1144 soundManager;
        private List<class_5481> nameLines = new ArrayList<class_5481>();
        private long lastClickTime;

        public ResourceLocationListEntry(ResourceLocationList parentList, class_2960 id, class_2561 name) {
            this.parentList = parentList;
            class_310 minecraft = this.parentList.field_22740;
            this.soundManager = minecraft.method_1483();
            this.font = minecraft.field_1772;
            this.id = id;
            this.isConfig = this.id.method_12832().contains("config");
            if (name != null) {
                this.nameLines = this.font.method_1728((class_5348)name, this.parentList.method_25322() - 8 - 2);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (class_156.method_658() - this.lastClickTime >= 250L) {
                this.lastClickTime = class_156.method_658();
                this.focus();
            } else {
                this.select();
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (class_8494.method_51255((int)keyCode)) {
                this.select();
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        private void focus() {
            this.parentList.method_25395((class_364)this);
            if (this.parentList.focusResponder != null) {
                this.parentList.focusResponder.accept(this.id);
            } else {
                Debug.error("There is no select responder for Resource Location List. Could not select location: " + this.id);
            }
        }

        private void select() {
            if (this.parentList.selectResponder != null) {
                this.parentList.selectResponder.accept(this.id);
                this.soundManager.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            } else {
                Debug.error("There is no accept responder for Resource Location List. Could not accept location: " + this.id);
            }
        }

        public void method_25343(@NotNull class_332 guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            x += 3;
            int mainColor = -1;
            int secondColor = -6250336;
            if (this.method_25370()) {
                mainColor = -256;
                secondColor = -377606;
            } else if (isHovering) {
                GuiContext context = new GuiContext(guiGraphics);
                context.fill(x, y - 2, width, height + 4, Colors.alpha(16, -1));
                context.fill(x + 1, y - 1, width - 2, height + 2, Colors.alpha(64, 0));
            }
            int nameX = x + 3;
            int nameY = y + 3;
            class_5481 nameFirstLine = this.nameLines.get(0);
            if (this.nameLines.size() == 1) {
                guiGraphics.method_35720(this.font, nameFirstLine, nameX, nameY, mainColor);
            } else {
                guiGraphics.method_35720(this.font, this.nameLines.get(1), nameX, nameY + 3, secondColor);
                guiGraphics.method_35720(this.font, nameFirstLine, nameX, nameY - 3, mainColor);
            }
            if (this.isConfig) {
                guiGraphics.method_27535(this.font, (class_2561)class_2561.method_43470((String)"c"), x + width - 10, nameY, -6250336);
            }
        }
    }

    protected static abstract class Entry
    extends class_4280.class_4281<Entry> {
        protected Entry() {
        }

        @NotNull
        public class_2561 method_37006() {
            return class_2561.method_43473();
        }
    }
}

