/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import net.bivrik.fancytoasts.client.gui.screen.ToastConfigScreen;
import net.bivrik.fancytoasts.client.registry.AnimationRegistry;
import net.bivrik.fancytoasts.client.registry.TextureRegistry;
import net.bivrik.fancytoasts.client.toast.DisplayData;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SettingType {
    TEXTURES("textures"){

        @Override
        public void apply(ToastConfigScreen instance, class_2960 id) {
            instance.getConfigData().setTextureId(id);
        }

        @Override
        public DisplayData getDisplayData(class_2960 id) {
            return TextureRegistry.getData(id);
        }

        @Override
        public class_2960 getCurrentId(ToastConfigScreen instance) {
            return instance.getConfigData().getTextureId();
        }

        @Override
        public class_2960[] getKeySet() {
            return TextureRegistry.getIds().toArray(new class_2960[0]);
        }
    }
    ,
    ANIMATIONS("animations"){

        @Override
        public void apply(ToastConfigScreen instance, class_2960 id) {
            instance.getConfigData().setAnimationId(id);
        }

        @Override
        public DisplayData getDisplayData(class_2960 id) {
            return AnimationRegistry.getData(id);
        }

        @Override
        public class_2960 getCurrentId(ToastConfigScreen instance) {
            return instance.getConfigData().getAnimationId();
        }

        @Override
        public class_2960[] getKeySet() {
            return AnimationRegistry.getIds().toArray(new class_2960[0]);
        }
    }
    ,
    SOUNDS("sounds"){

        @Override
        public void apply(ToastConfigScreen instance, class_2960 id) {
            instance.getConfigData().putSoundIdForType(id, instance.getAdvancementType());
        }

        @Override
        public DisplayData getDisplayData(class_2960 id) {
            String name = id.method_42094();
            DisplayData data = id.method_12836().equals("minecraft") ? new DisplayData(name, "Minecraft", Components.stringOf("toast.sound.minecraft.description"), false) : (class_7923.field_41172.method_10250(id) ? new DisplayData(name, id.method_12836(), Components.stringOf("toast.sound.mod.description"), false) : new DisplayData(name, id.method_12836(), Components.stringOf("toast.sound.resourcepack.description"), false));
            return data;
        }

        @Override
        public class_2960 getCurrentId(ToastConfigScreen instance) {
            return instance.getConfigData().getSoundIdByType(instance.getAdvancementType());
        }

        @Override
        public class_2960[] getKeySet() {
            return class_310.method_1551().method_1483().method_4864().toArray(new class_2960[0]);
        }
    };

    private final String name;

    public abstract void apply(ToastConfigScreen var1, class_2960 var2);

    public abstract DisplayData getDisplayData(class_2960 var1);

    public abstract class_2960 getCurrentId(ToastConfigScreen var1);

    public abstract class_2960[] getKeySet();

    private SettingType(String name) {
        this.name = name;
    }

    public class_2561 getDisplayName() {
        return Components.of("gui." + this.name);
    }

    public String getName() {
        return this.name;
    }
}

