/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.ToastAnchor;
import net.bivrik.fancytoasts.client.config.ToastScreenBehavior;
import net.bivrik.fancytoasts.client.config.data.GeneralConfigData;
import net.bivrik.fancytoasts.client.gui.IntegerEditBox;
import net.bivrik.fancytoasts.client.gui.Slider;
import net.bivrik.fancytoasts.client.gui.screen.UniversalScreen;
import net.bivrik.fancytoasts.client.toast.Appearance;
import net.bivrik.fancytoasts.core.Managers;
import net.bivrik.fancytoasts.core.event.GeneralConfigDataEvent;
import net.bivrik.fancytoasts.platform.Services;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.bivrik.fancytoasts.platform.utility.ResourceLocations;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class GeneralConfigScreen
extends UniversalScreen {
    private static final class_2561 TITLE = Components.of("title.general_settings");
    private static final class_2561 RESET_GENERAL_SETTINGS_TITLE = Components.of("title.reset_general_settings");
    private static final class_2561 RESET_GENERAL_SETTINGS_LABEL = Components.of("label.reset_general_settings");
    private static final class_2561 SAVED_LABEL = Components.of("label.saved");
    private static final class_2561 JADE_HIDING = Components.of("gui.jade_hiding");
    private static final class_2561 SOUNDS = Components.of("gui.sounds_enabled");
    private static final class_2561 SCREEN_BEHAVIOR = Components.of("gui.screen_behavior");
    private static final class_2561 TASK_VOLUME = Components.of("gui.task_volume");
    private static final class_2561 GOAL_VOLUME = Components.of("gui.goal_volume");
    private static final class_2561 CHALLENGE_VOLUME = Components.of("gui.challenge_volume");
    private static final class_2561 LOOPS_STRENGTH = Components.of("gui.loops_strength");
    private static final class_2561 LOOPS_SPEED = Components.of("gui.loops_speed");
    private static final class_2561 RESET = Components.of("gui.reset");
    private static final class_2561 ANCHOR = Components.of("gui.anchor");
    private static final class_2561 JADE_HIDING_TOOLTIP = Components.of("tooltip.jade_hiding");
    private static final class_2561 SOUNDS_TOOLTIP = Components.of("tooltip.sounds_enabled");
    private static final class_2561 SCREEN_BEHAVIOR_TOOLTIP = Components.of("tooltip.screen_behavior");
    private static final class_2561 ANCHOR_TOOLTIP = Components.of("tooltip.anchor");
    private static final class_2561 LOOPS_STRENGTH_TOOLTIP = Components.of("tooltip.loops_strength");
    private static final class_2561 LOOPS_SPEED_TOOLTIP = Components.of("tooltip.loops_speed");
    private static final class_2960 LIST_BACKGROUND = ResourceLocations.fromMinecraft("textures/gui/menu_list_background.png");
    private GeneralConfigData generalConfigData = Managers.getConfigManager().getGeneralConfigData();
    private boolean isSaved;
    private long savedFeedbackStartTime;
    private class_4185 doneButton;
    private class_4185 backButton;
    private class_4185 resetButton;
    private class_5676<Boolean> jadeHidingButton;
    private class_5676<Boolean> soundsEnabledButton;
    private class_5676<ToastScreenBehavior> toastScreenBehaviorButton;
    private class_5676<ToastAnchor> toastAnchorButton;
    private Slider loopsStrengthSlider;
    private Slider loopsSpeedSlider;
    private Slider taskVolumeSlider;
    private Slider goalVolumeSlider;
    private Slider challengeVolumeSlider;
    private IntegerEditBox offsetXEditBox;
    private IntegerEditBox offsetYEditBox;

    public GeneralConfigScreen(class_437 parent) {
        super(TITLE, parent);
    }

    protected void method_25426() {
        int xCenter = this.field_22789 / 2;
        this.backButton = this.addFWidget(this.createButton(class_5244.field_24339, button -> this.toParentScreen(), xCenter - 125 - 4, this.field_22790 - 20 - 6, 75, 20));
        this.resetButton = this.addFWidget(this.createButton(RESET, button -> this.confirmResetting(), xCenter - 50, this.field_22790 - 20 - 6, 50, 20));
        this.doneButton = this.addFWidget(this.createButton(class_5244.field_24334, button -> this.done(), xCenter + 4, this.field_22790 - 20 - 6, 125, 20));
        ListHelper listHelper = new ListHelper(this);
        if (Services.PLATFORM.isModLoaded("jade")) {
            this.jadeHidingButton = listHelper.addWidget(this.createBooleanButton(JADE_HIDING, this.generalConfigData.isJadeHiding(), (class_5676.class_5678<Boolean>)((class_5676.class_5678)(button, value) -> this.generalConfigData.setJadeHiding((boolean)value)), 0, 0, class_7919.method_47407((class_2561)JADE_HIDING_TOOLTIP)));
        }
        this.soundsEnabledButton = listHelper.addWidget(this.createBooleanButton(SOUNDS, this.generalConfigData.areSoundsEnabled(), (class_5676.class_5678<Boolean>)((class_5676.class_5678)(button, value) -> this.generalConfigData.setSoundsEnabled((boolean)value)), 0, 0, class_7919.method_47407((class_2561)SOUNDS_TOOLTIP)));
        this.toastScreenBehaviorButton = listHelper.addWidget(class_5676.method_32606(ToastScreenBehavior::getDisplayName).method_32624((Object[])ToastScreenBehavior.values()).method_32619((Object)this.generalConfigData.getToastScreenBehavior()).method_32618(toastScreenBehavior -> class_7919.method_47407((class_2561)SCREEN_BEHAVIOR_TOOLTIP)).method_32617(0, 0, 150, 20, SCREEN_BEHAVIOR, (button, value) -> this.generalConfigData.setToastScreenBehavior((ToastScreenBehavior)((Object)value))));
        this.toastAnchorButton = listHelper.addWidget(class_5676.method_32606(ToastAnchor::getDisplayName).method_32624((Object[])ToastAnchor.values()).method_32619((Object)this.generalConfigData.getToastAnchor()).method_32618(toastAnchor -> class_7919.method_47407((class_2561)ANCHOR_TOOLTIP)).method_32617(0, 0, 150, 20, ANCHOR, (button, value) -> this.generalConfigData.setToastAnchor((ToastAnchor)((Object)value))));
        this.offsetXEditBox = listHelper.addWidget(new IntegerEditBox(this.field_22793, 0, 0, 71, 20, this.offsetXEditBox, (class_2561)class_2561.method_43473(), this.generalConfigData.getOffsetX()));
        this.offsetXEditBox.method_1863(value -> this.offsetXEditBox.setIntegerValue(this.generalConfigData::setOffsetX));
        this.offsetYEditBox = listHelper.addWidget(new IntegerEditBox(this.field_22793, 0, 0, 71, 20, this.offsetYEditBox, (class_2561)class_2561.method_43473(), this.generalConfigData.getOffsetY()));
        this.offsetYEditBox.method_1863(value -> this.offsetYEditBox.setIntegerValue(this.generalConfigData::setOffsetY));
        this.loopsStrengthSlider = listHelper.addWidget(this.createSlider(LOOPS_STRENGTH, this.generalConfigData.getLoopsStrength(), 10.0f, 0.02f, this::multiplierDisplayer, this.generalConfigData::setLoopsStrength, 0, 0, class_7919.method_47407((class_2561)LOOPS_STRENGTH_TOOLTIP)));
        this.loopsSpeedSlider = listHelper.addWidget(this.createSlider(LOOPS_SPEED, this.generalConfigData.getLoopsSpeed(), 10.0f, 0.02f, this::multiplierDisplayer, this.generalConfigData::setLoopsSpeed, 0, 0, class_7919.method_47407((class_2561)LOOPS_SPEED_TOOLTIP)));
        this.taskVolumeSlider = listHelper.addWidget(this.createSlider(TASK_VOLUME, this.generalConfigData.getTaskVolume(), 2.0f, this::percentDisplayer, this.generalConfigData::setTaskVolume, 0, 0));
        this.goalVolumeSlider = listHelper.addWidget(this.createSlider(GOAL_VOLUME, this.generalConfigData.getGoalVolume(), 2.0f, this::percentDisplayer, this.generalConfigData::setGoalVolume, 0, 0));
        this.challengeVolumeSlider = listHelper.addWidget(this.createSlider(CHALLENGE_VOLUME, this.generalConfigData.getChallengeVolume(), 2.0f, this::percentDisplayer, this.generalConfigData::setChallengeVolume, 0, 0));
        listHelper.arrangeWidgets();
        listHelper.visitWidgets(this::addFWidget);
    }

    private void confirmResetting() {
        this.openScreen((class_437)new class_410(this::reset, RESET_GENERAL_SETTINGS_TITLE, RESET_GENERAL_SETTINGS_LABEL));
    }

    private void reset(boolean isConfirmed) {
        this.openScreen(this);
        if (!isConfirmed) {
            return;
        }
        this.generalConfigData = new GeneralConfigData();
        this.save(this.generalConfigData.copy());
        this.method_41843();
    }

    private void done() {
        GeneralConfigData data = this.generalConfigData.copy();
        if (!data.equals(Managers.getConfigManager().getGeneralConfigData())) {
            this.save(data);
        } else {
            this.toParentScreen();
        }
    }

    private void save(GeneralConfigData data) {
        ConfigHandler.save(data);
        Managers.getEventManager().changed(new GeneralConfigDataEvent(data));
        this.isSaved = true;
        this.savedFeedbackStartTime = class_156.method_658();
    }

    @Override
    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.drawBackground(guiGraphics);
        this.drawTitle(guiGraphics);
        this.drawListBackground(guiGraphics);
        this.drawRenderables(guiGraphics, mouseX, mouseY, partialTick);
        this.drawSavedFeedback(guiGraphics, this.field_22789 / 2 + 8 - 25 + 150, this.field_22790 - 20);
        this.drawPositionHints(guiGraphics);
    }

    private void drawPositionHints(class_332 guiGraphics) {
        if (this.offsetXEditBox == null || this.offsetYEditBox == null) {
            return;
        }
        int offsetX = 7;
        int offsetY = 5;
        guiGraphics.method_25303(this.field_22793, "x:", this.offsetXEditBox.method_46426() - offsetX, this.offsetXEditBox.method_46427() + offsetY, -6250336);
        guiGraphics.method_25303(this.field_22793, "y:", this.offsetYEditBox.method_46426() - offsetX, this.offsetYEditBox.method_46427() + offsetY, -6250336);
    }

    private void drawSavedFeedback(class_332 guiGraphics, int x, int y) {
        if (!this.isSaved) {
            return;
        }
        long time = class_156.method_658() - this.savedFeedbackStartTime;
        float appearanceLerp = MathEasing.easeOutLerp(0.0f, 1.0f, Appearance.getProgress(time, 500, 0));
        float disappearanceLerp = Appearance.getProgress(time, 500, 400);
        int color = Colors.alpha(appearanceLerp - disappearanceLerp, -256);
        guiGraphics.method_27535(this.field_22793, SAVED_LABEL, x, y, color);
        if (time > 850L) {
            this.isSaved = false;
        }
    }

    private void drawListBackground(class_332 guiGraphics) {
        int x0 = 0;
        int x1 = this.field_22789;
        int y0 = 32;
        int y1 = this.field_22790 - 32;
        guiGraphics.method_25294(x0, y0, x1, y1, 0x77000000);
        guiGraphics.method_51740(class_1921.method_51785(), x0, y0, x1, y0 + 4, -16777216, 0, 0);
        guiGraphics.method_51740(class_1921.method_51785(), x0, y1 - 4, x1, y1, 0, -16777216, 0);
    }

    private class_2561 multiplierDisplayer(float value) {
        return class_2561.method_43470((String)("x" + value));
    }

    private class_2561 percentDisplayer(float value) {
        return class_2561.method_43470((String)(Math.round(value * 100.0f) + "%"));
    }

    private static class ListHelper {
        private final List<class_339> widgets = new ArrayList<class_339>();
        private final class_437 parentScreen;

        private ListHelper(class_437 parentScreen) {
            this.parentScreen = parentScreen;
        }

        public <T extends class_339> T addWidget(T widget) {
            this.widgets.add(widget);
            return widget;
        }

        public void arrangeWidgets() {
            int y = 40;
            int xCenter = this.parentScreen.field_22789 / 2;
            int neighbours = 0;
            int numMinus = 0;
            for (int i = 0; i < this.widgets.size(); ++i) {
                class_339 widget = this.widgets.get(i);
                int x = xCenter;
                if (widget.method_25368() != 150) {
                    ++neighbours;
                }
                if (neighbours == 2) {
                    x += 79;
                    --i;
                }
                if (((i -= numMinus) & 1) == 0) {
                    if (i != 0 && neighbours != 2) {
                        y += 28;
                    }
                    x -= 154;
                } else {
                    x += 4;
                }
                i += numMinus;
                if (neighbours == 2) {
                    ++i;
                    ++numMinus;
                    neighbours = 0;
                }
                widget.method_48229(x, y);
            }
        }

        public void visitWidgets(Consumer<class_339> widgetConsumer) {
            this.widgets.forEach(widgetConsumer);
        }
    }
}

