/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui.screen;

import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.data.ToastConfigData;
import net.bivrik.fancytoasts.client.gui.InformationList;
import net.bivrik.fancytoasts.client.gui.ResourceLocationFilter;
import net.bivrik.fancytoasts.client.gui.ResourceLocationList;
import net.bivrik.fancytoasts.client.gui.SettingType;
import net.bivrik.fancytoasts.client.gui.screen.UniversalScreen;
import net.bivrik.fancytoasts.client.toast.Appearance;
import net.bivrik.fancytoasts.client.toast.DisplayData;
import net.bivrik.fancytoasts.core.Managers;
import net.bivrik.fancytoasts.core.event.ToastConfigDataEvent;
import net.bivrik.fancytoasts.core.manager.CustomTextureManager;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.bivrik.fancytoasts.platform.utility.FancyToastType;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.bivrik.fancytoasts.utility.file.Paths;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class ToastConfigScreen
extends UniversalScreen {
    private static final class_2561 TITLE = Components.of("title.visual_settings");
    private static final class_2561 SAVED_LABEL = Components.of("label.saved");
    private static final class_2561 CONFIG_FOLDER = Components.of("gui.config_folder");
    private static final class_2561 RELOAD_CUSTOMS = Components.of("gui.reload_customs");
    private static final class_2561 RELOAD_CUSTOMS_TOOLTIP = Components.of("tooltip.reload_customs");
    private final ToastConfigData toastConfigData;
    private final CustomTextureManager customTextureManager;
    private ResourceLocationFilter filter = ResourceLocationFilter.A_Z;
    private SettingType settingType = SettingType.TEXTURES;
    private FancyToastType advancementType = FancyToastType.TASK;
    private DisplayData selectedDisplayData;
    private boolean isSaved;
    private long savedFeedbackStartTime;
    private class_4185 doneButton;
    private class_4185 backButton;
    private class_4185 configsFolderButton;
    private class_4185 reloadConfigsButton;
    private class_5676<SettingType> settingTypeButton;
    private class_5676<ResourceLocationFilter> locationsFilterButton;
    private class_5676<FancyToastType> advancementTypeButton;
    private class_342 editBox;
    private ResourceLocationList locationsList;
    private InformationList informationList;

    public ToastConfigScreen(class_437 parent) {
        super(TITLE, parent);
        this.toastConfigData = Managers.getConfigManager().getToastConfigData();
        this.customTextureManager = Managers.getCustomTextureManager();
        this.customTextureManager.reload();
        this.selectedDisplayData = this.settingType.getDisplayData(this.toastConfigData.getTextureId());
    }

    public FancyToastType getAdvancementType() {
        return this.advancementType;
    }

    public ToastConfigData getConfigData() {
        return this.toastConfigData;
    }

    protected void method_25426() {
        int xCenter = this.field_22789 / 2;
        int yFirstRowBottom = this.field_22790 - 26;
        int ySecondRowBottom = yFirstRowBottom - 20 - 8;
        this.backButton = this.addFWidget(this.createButton(class_5244.field_24339, button -> this.toParentScreen(), xCenter - 100 - 25 - 4, yFirstRowBottom, 100, 20));
        this.doneButton = this.addFWidget(this.createButton(class_5244.field_24334, button -> this.done(), xCenter - 25 + 4, yFirstRowBottom));
        this.locationsList = this.addFWidget(new ResourceLocationList(this.field_22787, xCenter + 60 - 8, this.field_22790 - 20 - 8 - 64 - 2 - 20 - 8, xCenter - 60, 60, 18, this.settingType));
        this.locationsList.setSelectResponder(this::onSelectedEntry).setFocusResponder(this::onFocusedEntry);
        this.editBox = this.addFWidget(new class_342(this.field_22793, xCenter - 60, 32, xCenter - 40 - 30 - 32, 20, this.editBox, (class_2561)class_2561.method_43473()));
        this.editBox.method_1863(this.locationsList::setSearch);
        this.locationsFilterButton = this.addFWidget(class_5676.method_32606(ResourceLocationFilter::getDisplayName).method_32616().method_32624((Object[])ResourceLocationFilter.values()).method_32617(this.field_22789 - 80 - 16 - 60, 32, 60, 20, (class_2561)class_2561.method_43473(), (button, value) -> this.setFilter((ResourceLocationFilter)((Object)value), (class_364)button)));
        this.informationList = this.addFWidget(new InformationList(this.field_22787, xCenter - 60 - 16, this.field_22790 - 64 - 2 - 20 - 8, 8, 32, this.selectedDisplayData, this.settingType.getCurrentId(this).method_12832().contains("config")));
        this.settingTypeButton = this.addFWidget(class_5676.method_32606(SettingType::getDisplayName).method_32616().method_32624((Object[])SettingType.values()).method_32618(settingType -> this.getTooltip(settingType.getName())).method_32617(this.field_22789 - 88, 32, 80, 20, (class_2561)class_2561.method_43473(), (button, value) -> this.setSettingType((SettingType)((Object)value))));
        this.configsFolderButton = this.addFWidget(this.createButton(CONFIG_FOLDER, button -> this.openConfigsFolder(), xCenter - 43 - 8, ySecondRowBottom, 86, 20));
        this.reloadConfigsButton = this.addFWidget(this.createButton(RELOAD_CUSTOMS, button -> this.reloadCustomTextures(), xCenter + 129 - 86, ySecondRowBottom, 86, 20, class_7919.method_47407((class_2561)RELOAD_CUSTOMS_TOOLTIP)));
        this.advancementTypeButton = this.addFWidget(class_5676.method_32606(FancyToastType::getDisplayName).method_32616().method_32624((Object[])FancyToastType.values()).method_32618(advancementType -> this.getTooltip(advancementType.getName())).method_32617(xCenter - 129, ySecondRowBottom, 70, 20, (class_2561)class_2561.method_43473(), (button, value) -> this.setAdvancementType((FancyToastType)((Object)value))));
        this.tryToggleAdvancementTypeButton();
    }

    private class_7919 getTooltip(String valueName) {
        return class_7919.method_47407((class_2561)Components.of("tooltip." + valueName));
    }

    private void openConfigsFolder() {
        class_156.method_668().method_673(Paths.actualPath("./config/fancytoasts/").toUri());
    }

    private void reloadCustomTextures() {
        this.customTextureManager.reload();
        this.locationsList.setResourceLocations(this.settingType);
    }

    private void done() {
        ToastConfigData data = this.toastConfigData.copy();
        if (!data.equals(Managers.getConfigManager().getToastConfigData())) {
            this.save(data);
        } else {
            this.toParentScreen();
        }
    }

    private void save(ToastConfigData data) {
        class_2960 textureId = data.getTextureId();
        this.customTextureManager.releaseUnusedTexturesFromMinecraft();
        if (textureId.method_42094().contains("config")) {
            this.customTextureManager.registerInMinecraft(textureId);
        }
        ConfigHandler.save(data);
        Managers.getEventManager().changed(new ToastConfigDataEvent(data));
        this.isSaved = true;
        this.savedFeedbackStartTime = class_156.method_658();
    }

    @Override
    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.drawSavedFeedback(guiGraphics, this.field_22789 / 2 + 8 - 25 + 150, this.field_22790 - 20);
    }

    private void drawSavedFeedback(class_332 guiGraphics, int x, int y) {
        if (!this.isSaved) {
            return;
        }
        long time = class_156.method_658() - this.savedFeedbackStartTime;
        float appearanceLerp = MathEasing.easeOutLerp(0.0f, 1.0f, Appearance.getProgress(time, 500, 0));
        float disappearanceLerp = Appearance.getProgress(time, 500, 400);
        int color = Colors.alpha(appearanceLerp - disappearanceLerp, -256);
        guiGraphics.method_27535(this.field_22793, SAVED_LABEL, x, y, color);
        if (time > 850L) {
            this.isSaved = false;
        }
    }

    private <T extends class_364> void setFilter(ResourceLocationFilter filter, T button) {
        this.filter = filter;
        if (button == null) {
            this.locationsFilterButton.method_32605((Object)this.filter);
        }
        this.locationsList.setFilter(this.filter);
    }

    private void setSettingType(SettingType settingType) {
        this.settingType = settingType;
        this.locationsList.setResourceLocations(this.settingType);
        this.resetFiltering();
    }

    public void method_25410(@NotNull class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        this.resetFiltering();
    }

    private void resetFiltering() {
        this.editBox.method_1852("");
        this.setFilter(ResourceLocationFilter.A_Z, null);
        this.tryToggleAdvancementTypeButton();
    }

    private void tryToggleAdvancementTypeButton() {
        this.advancementTypeButton.field_22763 = this.settingType == SettingType.SOUNDS;
        this.informationList$updateOnReload();
    }

    private void setAdvancementType(FancyToastType type) {
        this.advancementType = type;
        this.informationList$updateOnReload();
    }

    private void informationList$updateOnReload() {
        this.informationList.update(this.settingType.getDisplayData(this.getCurrentId()), this.getCurrentId().method_12832().contains("config"), true);
    }

    private void onSelectedEntry(class_2960 location) {
        this.settingType.apply(this, location);
        this.informationList$updateSelected(location, true);
    }

    private void onFocusedEntry(class_2960 location) {
        this.selectedDisplayData = this.settingType.getDisplayData(location);
        boolean isSelected = this.getCurrentId().equals((Object)location);
        this.informationList$updateSelected(location, isSelected);
    }

    private void informationList$updateSelected(class_2960 location, boolean isSelected) {
        this.informationList.update(this.selectedDisplayData, location.method_12832().contains("config"), isSelected);
    }

    private class_2960 getCurrentId() {
        return this.settingType.getCurrentId(this);
    }
}

