/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.data.ToastsFilteringData;
import net.bivrik.fancytoasts.client.gui.screen.UniversalScreen;
import net.bivrik.fancytoasts.client.toast.Appearance;
import net.bivrik.fancytoasts.core.Managers;
import net.bivrik.fancytoasts.core.event.ToastsFilteringDataEvent;
import net.bivrik.fancytoasts.platform.Services;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.bivrik.fancytoasts.platform.utility.ResourceLocations;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.bivrik.fancytoasts.utility.file.Paths;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class ToastsFilteringScreen
extends UniversalScreen {
    private static final class_2561 TITLE = Components.of("title.toasts_filtering");
    private static final class_2561 RESET_TOASTS_FILTERING_TITLE = Components.of("title.reset_toasts_filtering");
    private static final class_2561 RESET_TOASTS_FILTERING_LABEL = Components.of("label.reset_toasts_filtering");
    private static final class_2561 SAVED_LABEL = Components.of("label.saved");
    private static final class_2561 RESET = Components.of("gui.reset");
    private static final class_2561 FANCY_ADVANCEMENT_TOASTS = Components.of("gui.fancy_advancement_toasts");
    private static final class_2561 ADVANCEMENT_TOASTS = Components.of("gui.advancement_toasts");
    private static final class_2561 FANCY_QUEST_TOASTS = Components.of("gui.fancy_quest_toasts");
    private static final class_2561 RECIPE_TOASTS = Components.of("gui.recipe_toasts");
    private static final class_2561 SYSTEM_TOASTS = Components.of("gui.system_toasts");
    private static final class_2561 TUTORIAL_TOASTS = Components.of("gui.tutorial_toasts");
    private static final class_2561 IGNORED_TOASTS = Components.of("gui.ignored_toasts");
    private static final class_2561 TOASTS_FILTERING_TOOLTIP = Components.of("tooltip.toasts_filtering");
    private static final class_2960 LIST_BACKGROUND = ResourceLocations.fromMinecraft("textures/gui/menu_list_background.png");
    private ToastsFilteringData toastsFilteringData = Managers.getConfigManager().getToastsFilteringData();
    private boolean isSaved;
    private long savedFeedbackStartTime;
    private class_4185 doneButton;
    private class_4185 backButton;
    private class_4185 resetButton;
    private class_4185 toastsFilteringFileButton;
    private class_5676<Boolean> fancyAdvancementToastsButton;
    private class_5676<Boolean> fancyQuestToastsButton;
    private class_5676<Boolean> advancementToastsButton;
    private class_5676<Boolean> recipeToastsButton;
    private class_5676<Boolean> systemToastsButton;
    private class_5676<Boolean> tutorialToastsButton;

    public ToastsFilteringScreen(class_437 parent) {
        super(TITLE, parent);
    }

    protected void method_25426() {
        int xCenter = this.field_22789 / 2;
        this.backButton = this.addFWidget(this.createButton(class_5244.field_24339, button -> this.toParentScreen(), xCenter - 125 - 4, this.field_22790 - 20 - 6, 75, 20));
        this.resetButton = this.addFWidget(this.createButton(RESET, button -> this.confirmResetting(), xCenter - 50, this.field_22790 - 20 - 6, 50, 20));
        this.doneButton = this.addFWidget(this.createButton(class_5244.field_24334, button -> this.done(), xCenter + 4, this.field_22790 - 20 - 6, 125, 20));
        ListHelper listHelper = new ListHelper(this);
        this.fancyAdvancementToastsButton = listHelper.addWidget(this.createBooleanButton(FANCY_ADVANCEMENT_TOASTS, this.toastsFilteringData.isFancyAdvancementToastsEnabled(), (class_5676.class_5678<Boolean>)((class_5676.class_5678)(button, value) -> this.toastsFilteringData.setFancyAdvancementToastsEnabled((boolean)value)), 0, 0));
        if (Services.PLATFORM.isModLoaded("ftbquests")) {
            this.fancyQuestToastsButton = listHelper.addWidget(this.createBooleanButton(FANCY_QUEST_TOASTS, this.toastsFilteringData.isFancyQuestToastsEnabled(), (class_5676.class_5678<Boolean>)((class_5676.class_5678)(button, value) -> this.toastsFilteringData.setFancyQuestToastsEnabled((boolean)value)), 0, 0));
        }
        this.advancementToastsButton = listHelper.addWidget(this.createBooleanButton(ADVANCEMENT_TOASTS, this.toastsFilteringData.isAdvancementToastsEnabled(), (class_5676.class_5678<Boolean>)((class_5676.class_5678)(button, value) -> this.toastsFilteringData.setAdvancementToastsEnabled((boolean)value)), 0, 0));
        this.recipeToastsButton = listHelper.addWidget(this.createBooleanButton(RECIPE_TOASTS, this.toastsFilteringData.isRecipeToastsEnabled(), (class_5676.class_5678<Boolean>)((class_5676.class_5678)(button, value) -> this.toastsFilteringData.setRecipeToastsEnabled((boolean)value)), 0, 0));
        this.systemToastsButton = listHelper.addWidget(this.createBooleanButton(SYSTEM_TOASTS, this.toastsFilteringData.isSystemToastsEnabled(), (class_5676.class_5678<Boolean>)((class_5676.class_5678)(button, value) -> this.toastsFilteringData.setSystemToastsEnabled((boolean)value)), 0, 0));
        this.tutorialToastsButton = listHelper.addWidget(this.createBooleanButton(TUTORIAL_TOASTS, this.toastsFilteringData.isTutorialToastsEnabled(), (class_5676.class_5678<Boolean>)((class_5676.class_5678)(button, value) -> this.toastsFilteringData.setTutorialToastsEnabled((boolean)value)), 0, 0));
        this.toastsFilteringFileButton = listHelper.addWidget(this.createButton(IGNORED_TOASTS, button -> this.openToastsFilteringFile(), 0, 0, class_7919.method_47407((class_2561)TOASTS_FILTERING_TOOLTIP)));
        listHelper.arrangeWidgets();
        listHelper.visitWidgets(this::addFWidget);
    }

    private void openToastsFilteringFile() {
        class_156.method_668().method_673(Paths.actualPath("./config/fancytoasts/toast_filtering.json").toUri());
    }

    private void confirmResetting() {
        this.openScreen((class_437)new class_410(this::reset, RESET_TOASTS_FILTERING_TITLE, RESET_TOASTS_FILTERING_LABEL));
    }

    private void reset(boolean isConfirmed) {
        this.openScreen(this);
        if (!isConfirmed) {
            return;
        }
        this.toastsFilteringData = new ToastsFilteringData();
        this.save(this.toastsFilteringData.copy());
        this.method_41843();
    }

    private void done() {
        ToastsFilteringData data = this.toastsFilteringData.copy();
        if (!data.equals(Managers.getConfigManager().getToastsFilteringData())) {
            this.save(data);
        } else {
            this.toParentScreen();
        }
    }

    private void save(ToastsFilteringData data) {
        ConfigHandler.save(data);
        Managers.getEventManager().changed(new ToastsFilteringDataEvent(data));
        this.isSaved = true;
        this.savedFeedbackStartTime = class_156.method_658();
    }

    @Override
    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.drawBackground(guiGraphics);
        this.drawTitle(guiGraphics);
        this.drawListBackground(guiGraphics);
        this.drawRenderables(guiGraphics, mouseX, mouseY, partialTick);
        this.drawSavedFeedback(guiGraphics, this.field_22789 / 2 + 8 - 25 + 150, this.field_22790 - 20);
    }

    private void drawSavedFeedback(class_332 guiGraphics, int x, int y) {
        if (!this.isSaved) {
            return;
        }
        long time = class_156.method_658() - this.savedFeedbackStartTime;
        float appearanceLerp = MathEasing.easeOutLerp(0.0f, 1.0f, Appearance.getProgress(time, 500, 0));
        float disappearanceLerp = Appearance.getProgress(time, 500, 400);
        int color = Colors.alpha(appearanceLerp - disappearanceLerp, -256);
        guiGraphics.method_27535(this.field_22793, SAVED_LABEL, x, y, color);
        if (time > 850L) {
            this.isSaved = false;
        }
    }

    private void drawListBackground(class_332 guiGraphics) {
        int x0 = 0;
        int x1 = this.field_22789;
        int y0 = 32;
        int y1 = this.field_22790 - 32;
        guiGraphics.method_25294(x0, y0, x1, y1, 0x77000000);
        guiGraphics.method_51740(class_1921.method_51785(), x0, y0, x1, y0 + 4, -16777216, 0, 0);
        guiGraphics.method_51740(class_1921.method_51785(), x0, y1 - 4, x1, y1, 0, -16777216, 0);
    }

    private static class ListHelper {
        private final List<class_339> widgets = new ArrayList<class_339>();
        private final class_437 parentScreen;

        private ListHelper(class_437 parentScreen) {
            this.parentScreen = parentScreen;
        }

        public <T extends class_339> T addWidget(T widget) {
            this.widgets.add(widget);
            return widget;
        }

        public void arrangeWidgets() {
            int y = 40;
            int xCenter = this.parentScreen.field_22789 / 2;
            for (int i = 0; i < this.widgets.size(); ++i) {
                int x = xCenter;
                if ((i & 1) == 0) {
                    if (i != 0) {
                        y += 28;
                    }
                    x -= 154;
                } else {
                    x += 4;
                }
                this.widgets.get(i).method_48229(x, y);
            }
        }

        public void visitWidgets(Consumer<class_339> widgetConsumer) {
            this.widgets.forEach(widgetConsumer);
        }
    }
}

