/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.bivrik.fancytoasts.client.registry.TextureRegistry;
import net.bivrik.fancytoasts.client.toast.DisplayData;
import net.bivrik.fancytoasts.client.toast.animation.FancyToastAnimation;
import net.bivrik.fancytoasts.client.toast.animation.StandardAnimation;
import net.bivrik.fancytoasts.core.Debug;
import net.minecraft.class_2960;
import org.slf4j.Logger;

public class AnimationRegistry {
    private static final Logger LOGGER = Debug.getLogger(AnimationRegistry.class);
    private static final Map<class_2960, AnimationHandler> ANIMATIONS = new HashMap<class_2960, AnimationHandler>();

    private static void addAnimation(class_2960 id, AnimationHandler handler) {
        ANIMATIONS.put(id, handler);
    }

    public static boolean register(class_2960 id, Supplier<FancyToastAnimation> animation, DisplayData data) {
        if (ANIMATIONS.containsKey(id)) {
            LOGGER.warn("{} already exists! It has to be unique", (Object)id);
            return false;
        }
        AnimationRegistry.addAnimation(id, new AnimationHandler(animation, data));
        LOGGER.info("Registered: {}", (Object)id);
        return true;
    }

    public static boolean register(class_2960 id, Supplier<FancyToastAnimation> animation, String name, String author, String description) {
        return AnimationRegistry.register(id, animation, new DisplayData(name, author, description, true));
    }

    public static boolean isRegistered(class_2960 id) {
        return ANIMATIONS.getOrDefault(id, null) != null;
    }

    private static AnimationHandler getAnimationHandler(class_2960 id) {
        AnimationHandler data = ANIMATIONS.getOrDefault(id, null);
        if (data == null) {
            LOGGER.error("{} is missing, using default", (Object)id);
            return AnimationRegistry.getDefaultAnimationHandler();
        }
        return data;
    }

    private static AnimationHandler getDefaultAnimationHandler() {
        return new AnimationHandler(StandardAnimation::new, TextureRegistry.getDefaultData());
    }

    public static DisplayData getData(class_2960 id) {
        return AnimationRegistry.getAnimationHandler((class_2960)id).data;
    }

    public static Supplier<FancyToastAnimation> getAnimation(class_2960 id) {
        return AnimationRegistry.getAnimationHandler((class_2960)id).animationFactory;
    }

    public static Collection<class_2960> getIds() {
        return ANIMATIONS.keySet();
    }

    public record AnimationHandler(Supplier<FancyToastAnimation> animationFactory, DisplayData data) {
    }
}

