/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.bivrik.fancytoasts.client.toast.DisplayData;
import net.bivrik.fancytoasts.core.Debug;
import net.minecraft.class_2960;
import org.slf4j.Logger;

public class TextureRegistry {
    private static final Logger LOGGER = Debug.getLogger(TextureRegistry.class);
    private static final Map<class_2960, DisplayData> TEXTURES = new HashMap<class_2960, DisplayData>();

    private static void addTexture(class_2960 id, DisplayData data) {
        TEXTURES.put(id, data);
    }

    public static boolean register(class_2960 id, DisplayData data) {
        if (TextureRegistry.isRegistered(id)) {
            LOGGER.warn("{} already exists! It has to be unique", (Object)id);
            return false;
        }
        TextureRegistry.addTexture(id, data);
        LOGGER.info("Registered: {}", (Object)id);
        return true;
    }

    public static boolean register(class_2960 id, String name, String author, String description) {
        return TextureRegistry.register(id, new DisplayData(name, author, description, true));
    }

    public static void unregister(class_2960 id) {
        TEXTURES.remove(id);
        LOGGER.info("Unregistered: {}", (Object)id);
    }

    public static boolean isRegistered(class_2960 id) {
        return TEXTURES.getOrDefault(id, null) != null;
    }

    public static DisplayData getData(class_2960 id) {
        DisplayData data = TEXTURES.getOrDefault(id, null);
        if (data == null) {
            LOGGER.error("{} is missing, using default", (Object)id);
            return TextureRegistry.getDefaultData();
        }
        return data;
    }

    public static DisplayData getDefaultData() {
        return new DisplayData("fancytoasts.gui.unknown", "fancytoasts.gui.unknown", "fancytoasts.gui.unknown", true);
    }

    public static Collection<class_2960> getIds() {
        return TEXTURES.keySet();
    }

    public static List<class_2960> getCustomIds() {
        return TEXTURES.keySet().stream().filter(id -> id.method_12832().contains("config")).collect(Collectors.toList());
    }
}

