/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast;

import net.bivrik.fancytoasts.platform.utility.Components;
import net.minecraft.class_2561;

public class DisplayData {
    private static final class_2561 UNKNOWN_LABEL = Components.of("label.unknown");
    private final class_2561 displayName;
    private final class_2561 displayAuthor;
    private final class_2561 displayDescription;

    public DisplayData(String name, String author, String description, boolean isTranslatableName) {
        this.displayName = name != null ? (isTranslatableName ? class_2561.method_43471((String)name) : class_2561.method_43470((String)DisplayData.getVisualAppealingString(name))) : UNKNOWN_LABEL;
        this.displayAuthor = author != null ? class_2561.method_43470((String)DisplayData.getVisualAppealingString(author)) : UNKNOWN_LABEL;
        this.displayDescription = description != null ? class_2561.method_43471((String)description) : UNKNOWN_LABEL;
    }

    public DisplayData(DTO dto) {
        this(dto.name, dto.author, dto.description, false);
    }

    public class_2561 getDisplayName() {
        return this.displayName;
    }

    public class_2561 getDisplayDescription() {
        return this.displayDescription;
    }

    public class_2561 getAuthor() {
        return this.displayAuthor;
    }

    public static String getVisualAppealingString(String stringToConvert) {
        if (stringToConvert == null || stringToConvert.isEmpty()) {
            return "";
        }
        if (DisplayData.isVisualAppealing(stringToConvert)) {
            return stringToConvert;
        }
        String visualAppealingString = stringToConvert.replace('.', ' ').replace('_', ' ').trim();
        if (visualAppealingString.isBlank()) {
            return "";
        }
        String firstLetter = visualAppealingString.substring(0, 1).toUpperCase();
        String leftovers = visualAppealingString.substring(1);
        return firstLetter + leftovers;
    }

    private static boolean isVisualAppealing(String stringToCheck) {
        return !stringToCheck.contains(".") && Character.isUpperCase(stringToCheck.charAt(0)) && !stringToCheck.contains("_");
    }

    public String toString() {
        return String.format("DisplayData{name='%s', author='%s', description='%s'}", this.displayAuthor.getString(), this.displayAuthor.getString(), this.displayDescription.getString());
    }

    public record DTO(String name, String author, String description) {
    }
}

