/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast;

import java.util.Random;
import net.bivrik.fancytoasts.client.config.data.GeneralConfigData;
import net.bivrik.fancytoasts.client.registry.AnimationRegistry;
import net.bivrik.fancytoasts.client.toast.AnimationSetup;
import net.bivrik.fancytoasts.client.toast.animation.FancyToastAnimation;
import net.bivrik.fancytoasts.core.Debug;
import net.bivrik.fancytoasts.core.Managers;
import net.bivrik.fancytoasts.platform.utility.ToastDisplayInfo;
import net.bivrik.fancytoasts.utility.DefaultUVs;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class FancyAdvancementToast {
    private static final int WIDTH = 162;
    private static final int HEIGHT = 70;
    private static final Random random = new Random();
    private FancyToastAnimation animation;
    private class_2960 toastSoundId;
    private float volume;
    private class_1144 soundManager;
    private long time;
    private boolean isEnded = false;
    private int playedSoundsCount = 0;

    public FancyAdvancementToast(class_310 minecraft, ToastDisplayInfo displayInfo, class_2960 textureId, class_2960 animationId) {
        GeneralConfigData generalConfig = Managers.getConfigManager().getGeneralConfigData();
        if (generalConfig.areSoundsEnabled()) {
            this.soundManager = minecraft.method_1483();
        }
        AnimationSetup setup = new AnimationSetup(textureId, displayInfo, null, DefaultUVs.BACKGROUND, DefaultUVs.PLAQUE);
        switch (displayInfo.getAdvancementType()) {
            case TASK: {
                setup.setTypeBasedUVs(DefaultUVs.TASK);
                this.volume = generalConfig.getTaskVolume();
                break;
            }
            case GOAL: {
                setup.setTypeBasedUVs(DefaultUVs.GOAL);
                this.volume = generalConfig.getGoalVolume();
                break;
            }
            case CHALLENGE: {
                setup.setTypeBasedUVs(DefaultUVs.CHALLENGE);
                this.volume = generalConfig.getChallengeVolume();
                break;
            }
            default: {
                throw new RuntimeException("Could match correct advancement type");
            }
        }
        this.animation = AnimationRegistry.getAnimation(animationId).get();
        this.animation.setup(setup, minecraft, this.getWidth(), this.getHeight());
        this.toastSoundId = Managers.getConfigManager().getToastConfigData().getSoundIdByType(displayInfo.getAdvancementType());
        Debug.info("Created new fancy advancement toast: {}; texture: {}; animation: {}", displayInfo.getTitle().getString(), textureId, animationId);
    }

    public void draw(class_332 graphics) {
        this.animation.draw(graphics, this.time);
    }

    public void update(long time) {
        this.time = time;
        if (this.time >= (long)this.animation.getDuration()) {
            this.isEnded = true;
        }
        if (this.soundManager != null) {
            int timeInSeconds = (int)(this.time / 50L);
            switch (this.playedSoundsCount) {
                case 0: {
                    this.playSound(class_3417.field_14561, 1.5f);
                    break;
                }
                case 1: {
                    if (timeInSeconds != this.animation.getToastSoundTiming() / 50) break;
                    this.playSound(this.toastSoundId, this.volume);
                    break;
                }
                case 2: {
                    if (timeInSeconds != this.animation.getDuration() / 50 - 10) break;
                    this.playSound(class_3417.field_14561, 1.5f);
                }
            }
        }
    }

    private void playSound(class_3414 sound, float volume) {
        this.soundManager.method_4873((class_1113)class_1109.method_4757((class_3414)sound, (float)random.nextFloat(0.95f, 1.05f), (float)volume));
        ++this.playedSoundsCount;
    }

    private void playSound(class_2960 soundLocation, float volume) {
        this.playSound(class_3414.method_47908((class_2960)soundLocation), volume);
    }

    public boolean isEnded() {
        return this.isEnded;
    }

    public int getWidth() {
        return 162;
    }

    public int getHeight() {
        return 70;
    }
}

