/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import java.util.List;
import java.util.Objects;
import net.bivrik.fancytoasts.client.config.ToastScreenBehavior;
import net.bivrik.fancytoasts.client.config.data.GeneralConfigData;
import net.bivrik.fancytoasts.client.toast.AnimationSetup;
import net.bivrik.fancytoasts.core.Managers;
import net.bivrik.fancytoasts.core.event.GeneralConfigDataEvent;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.GuiContext;
import net.bivrik.fancytoasts.platform.utility.ToastDisplayInfo;
import net.bivrik.fancytoasts.utility.TextureUV;
import net.bivrik.fancytoasts.utility.TypeBasedUVs;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public abstract class FancyToastAnimation {
    private List<class_5481> titleLines;
    private List<class_5481> descriptionLines;
    protected ToastDisplayInfo displayInfo;
    protected class_310 minecraft;
    protected int toastWidth;
    protected int toastHeight;
    private class_2960 textureLocation;
    private TypeBasedUVs typeBasedUVs;
    private TextureUV backgroundUV;
    private TextureUV plaqueUV;
    private float guiAlpha = 1.0f;
    private boolean shouldTransparentToast;
    private float loopsStrength;
    private float loopsSpeed;
    private static final float TIME_SCALE = 0.00125f;

    public void setup(AnimationSetup setup, class_310 minecraft, int toastWidth, int toastHeight) {
        Managers.getEventManager().subscribe(GeneralConfigDataEvent.class, this::onGeneralConfigDataChanged);
        GeneralConfigData data = Managers.getConfigManager().getGeneralConfigData();
        this.shouldTransparentToast = data.getToastScreenBehavior().equals((Object)ToastScreenBehavior.TRANSPARENT);
        this.loopsStrength = data.getLoopsStrength();
        this.loopsSpeed = data.getLoopsSpeed();
        this.minecraft = minecraft;
        this.toastWidth = toastWidth;
        this.toastHeight = toastHeight;
        this.textureLocation = setup.textureLocation();
        this.displayInfo = setup.displayInfo();
        this.typeBasedUVs = setup.typeBasedUVs();
        this.backgroundUV = setup.backgroundUV();
        this.plaqueUV = setup.plaqueUV();
    }

    private void onGeneralConfigDataChanged(GeneralConfigDataEvent event) {
        GeneralConfigData data = event.generalConfigData();
        this.shouldTransparentToast = data.getToastScreenBehavior().equals((Object)ToastScreenBehavior.TRANSPARENT);
        this.loopsStrength = data.getLoopsStrength();
        this.loopsSpeed = data.getLoopsSpeed();
    }

    protected void setLines(class_2561 title, class_2561 description) {
        this.titleLines = this.minecraft.field_1772.method_1728((class_5348)title, 142);
        this.descriptionLines = this.minecraft.field_1772.method_1728((class_5348)description, 142);
    }

    protected List<class_5481> getTitleLines() {
        return this.titleLines;
    }

    protected List<class_5481> getDescriptionLines() {
        return this.descriptionLines;
    }

    public void draw(class_332 guiGraphics, long time) {
        if (this.shouldTransparentToast && Objects.requireNonNull(Managers.getToastManager()).isScreenOpened()) {
            this.guiAlpha = 0.5f;
        } else if (this.guiAlpha != 1.0f) {
            this.guiAlpha = 1.0f;
        }
    }

    public abstract int getDuration();

    public abstract int getToastSoundTiming();

    protected void drawIcon(GuiContext guiContext, float alpha) {
        guiContext.drawGUITexture(this.textureLocation, 68, 0, 26, 26, this.typeBasedUVs.frame(), this.getColor(alpha));
        guiContext.guiGraphics().method_51445(this.displayInfo.getIcon(), 73, 5);
    }

    protected void drawIcon(GuiContext guiContext) {
        this.drawIcon(guiContext, 1.0f);
    }

    protected void drawBanner(GuiContext guiContext, float alpha) {
        guiContext.drawGUITexture(this.textureLocation, 0, 5, 162, 14, this.typeBasedUVs.banner(), this.getColor(alpha));
    }

    protected void drawBanner(GuiContext guiContext) {
        this.drawBanner(guiContext, 1.0f);
    }

    protected void drawBackground(GuiContext guiContext, float alpha) {
        int color = this.getColor(alpha);
        guiContext.drawGUITexture(this.textureLocation, 0, 20, 162, 40, this.backgroundUV, color);
        guiContext.drawGUITexture(this.textureLocation, 144, 56, 9, 14, this.plaqueUV, color);
    }

    protected void drawBackground(GuiContext guiContext) {
        this.drawBackground(guiContext, 1.0f);
    }

    protected void drawTitle(class_332 guiGraphics, float alpha) {
        if (this.titleLines.isEmpty()) {
            return;
        }
        int toastCenterX = this.toastWidth / 2;
        int titleColor = Colors.alpha(alpha, this.displayInfo.getAdvancementType().getMainColor());
        class_5481 titleLine = this.titleLines.get(0);
        if (this.titleLines.size() == 1) {
            guiGraphics.method_35719(this.minecraft.field_1772, titleLine, toastCenterX, 25, titleColor);
        } else {
            guiGraphics.method_35719(this.minecraft.field_1772, titleLine, toastCenterX - this.minecraft.field_1772.method_1727("...") / 2, 25, titleColor);
            guiGraphics.method_25300(this.minecraft.field_1772, "...", toastCenterX + 1 + this.minecraft.field_1772.method_30880(titleLine) / 2, 25, titleColor);
        }
    }

    protected void drawTitle(class_332 guiGraphics) {
        this.drawTitle(guiGraphics, 1.0f);
    }

    protected void drawDescription(class_332 guiGraphics, float alpha) {
        if (this.descriptionLines.isEmpty()) {
            return;
        }
        int descriptionColor = Colors.alpha(alpha, this.displayInfo.getAdvancementType().getSecondaryColor());
        guiGraphics.method_35720(this.minecraft.field_1772, this.descriptionLines.get(0), 8, 38, descriptionColor);
        if (this.descriptionLines.size() > 1) {
            class_5481 descriptionSecondLine = this.descriptionLines.get(1);
            guiGraphics.method_35720(this.minecraft.field_1772, descriptionSecondLine, 8, 47, descriptionColor);
            if (this.descriptionLines.size() > 2) {
                guiGraphics.method_25303(this.minecraft.field_1772, "...", 8 + this.minecraft.field_1772.method_30880(descriptionSecondLine), 47, descriptionColor);
            }
        }
    }

    protected void drawDescription(class_332 guiGraphics) {
        this.drawDescription(guiGraphics, 1.0f);
    }

    protected float sinusoidLoop(long time, float speed, float strength) {
        float scaledTime = (float)time * 0.00125f * speed * this.loopsSpeed;
        return (float)Math.sin(scaledTime) * strength * this.loopsStrength;
    }

    protected float cosineLoop(long time, float speed, float strength) {
        float scaledTime = (float)time * 0.00125f * speed * this.loopsSpeed;
        return (float)Math.cos(scaledTime) * strength * this.loopsStrength;
    }

    protected int getColor(float alpha) {
        return Colors.alpha(this.guiAlpha * alpha, -1);
    }
}

