/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bivrik.fancytoasts.core.IManager;
import net.bivrik.fancytoasts.core.ITickableManager;
import net.bivrik.fancytoasts.core.manager.ConfigManager;
import net.bivrik.fancytoasts.core.manager.CreditsManager;
import net.bivrik.fancytoasts.core.manager.CustomTextureManager;
import net.bivrik.fancytoasts.core.manager.EventManager;
import net.bivrik.fancytoasts.core.manager.KeyBindingManager;
import net.bivrik.fancytoasts.core.manager.SplashManager;
import net.bivrik.fancytoasts.core.manager.ToastManager;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class Managers {
    private static final Map<Class<? extends IManager>, IManager> MANAGERS = new HashMap<Class<? extends IManager>, IManager>();
    private static final List<ITickableManager> TICKABLE_MANAGERS = new ArrayList<ITickableManager>();

    public static void init() {
        Managers.registerManager(ConfigManager.class, new ConfigManager());
        Managers.registerManager(EventManager.class, new EventManager());
        Managers.registerManager(KeyBindingManager.class, new KeyBindingManager());
        Managers.registerManager(SplashManager.class, new SplashManager());
        Managers.registerManager(CreditsManager.class, new CreditsManager());
        Managers.registerManager(CustomTextureManager.class, new CustomTextureManager());
        Managers.registerManager(ToastManager.class, new ToastManager());
    }

    public static void onModInit() {
        MANAGERS.values().forEach(IManager::onModInit);
    }

    public static void onMinecraftInit(class_310 minecraft) {
        MANAGERS.values().forEach(managerProvider -> managerProvider.onMinecraftInit(minecraft));
    }

    public static void onTick() {
        for (ITickableManager tickableManager : TICKABLE_MANAGERS) {
            tickableManager.onTick();
        }
    }

    private static <T extends IManager> void registerManager(Class<T> managerClass, T managerInstance) {
        MANAGERS.put(managerClass, managerInstance);
        if (managerInstance instanceof ITickableManager) {
            ITickableManager tickableManager = (ITickableManager)managerInstance;
            TICKABLE_MANAGERS.add(tickableManager);
        }
    }

    private static <T extends IManager> T get(Class<T> managerClass) {
        IManager result = MANAGERS.get(managerClass);
        if (result == null) {
            throw new IllegalStateException("Trying to access unregistered manager: " + managerClass.getSimpleName());
        }
        return (T)result;
    }

    public static ConfigManager getConfigManager() {
        return Managers.get(ConfigManager.class);
    }

    public static EventManager getEventManager() {
        return Managers.get(EventManager.class);
    }

    public static KeyBindingManager getKeyBindingManager() {
        return Managers.get(KeyBindingManager.class);
    }

    public static SplashManager getSplashManager() {
        return Managers.get(SplashManager.class);
    }

    public static CreditsManager getCreditsManager() {
        return Managers.get(CreditsManager.class);
    }

    public static CustomTextureManager getCustomTextureManager() {
        return Managers.get(CustomTextureManager.class);
    }

    @Nullable
    public static ToastManager getToastManager() {
        try {
            return Managers.get(ToastManager.class);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }
}

